/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.Key;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import net.messagevortex.asn1.encryption.Parameter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SymmetricKey
extends Key
implements Serializable {
    public static final long serialVersionUID = 100000000040L;
    private static final ExtendedSecureRandom secureRandom = new ExtendedSecureRandom();
    protected byte[] key = null;

    public SymmetricKey() throws IOException {
        this(Algorithm.getDefault(AlgorithmType.SYMMETRIC));
    }

    public SymmetricKey(Algorithm sk) throws IOException {
        this(sk, Padding.getDefault(AlgorithmType.SYMMETRIC), Mode.getDefault(AlgorithmType.SYMMETRIC));
    }

    public SymmetricKey(Algorithm sk, Padding pad, Mode mode) throws IOException {
        if (pad == null) {
            throw new NullPointerException("padding may not be null");
        }
        if (mode == null) {
            throw new NullPointerException("mode may not be null");
        }
        this.parameters.put(Parameter.ALGORITHM, sk.toString());
        this.parameters.put(Parameter.PADDING, pad.toString());
        this.parameters.put(Parameter.MODE, mode.toString());
        if (sk.toString().toLowerCase().startsWith("aes")) {
            this.createAes(sk.getKeySize());
        } else if (sk.toString().toLowerCase().startsWith("camellia")) {
            this.createCamellia(sk.getKeySize());
        } else if (sk.toString().toLowerCase().startsWith("twofish")) {
            this.createTwofish(sk.getKeySize());
        } else {
            throw new IOException("Algorithm " + String.valueOf(sk) + " is not encodable by the system");
        }
    }

    public SymmetricKey(byte[] sk) throws IOException {
        this(sk, null);
    }

    public SymmetricKey(byte[] sk, AsymmetricKey deckey) throws IOException {
        ASN1Primitive s;
        if (deckey != null) {
            byte[] b;
            try {
                b = deckey.decrypt(sk);
            }
            catch (Exception e) {
                throw new IOException("Error while decrypting object", e);
            }
            s = DERSequence.fromByteArray((byte[])b);
        } else {
            s = DERSequence.fromByteArray((byte[])sk);
        }
        this.parse((ASN1Encodable)s);
    }

    public byte[] setIv(byte[] b) {
        String s = this.parameters.get(Parameter.IV);
        byte[] old = s == null ? null : s.getBytes(StandardCharsets.UTF_8);
        if (b == null || b.length == 0) {
            this.parameters.put(Parameter.IV, SymmetricKey.toHex(ExtendedSecureRandom.generateSeed(16)));
        } else {
            this.parameters.put(Parameter.IV, SymmetricKey.toHex(b));
        }
        return old;
    }

    public byte[] getIv() {
        return SymmetricKey.fromHex(this.parameters.get(Parameter.IV));
    }

    public AlgorithmParameter getParameter() {
        return new AlgorithmParameter(this.parameters);
    }

    public Padding getPadding() {
        return Padding.getByString(this.parameters.get(Parameter.PADDING.toString()));
    }

    public int getKeySize() {
        return this.parameters.get(Parameter.KEYSIZE) != null ? Integer.parseInt(this.parameters.get(Parameter.KEYSIZE)) : this.getAlgorithm().getKeySize();
    }

    public Mode getMode() {
        return Mode.getByString(this.parameters.get(Parameter.MODE.toString()));
    }

    public Algorithm getAlgorithm() {
        return Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
    }

    private void createAes(int keysize) {
        Mode mode = this.getMode();
        byte[] keyBytes = new byte[keysize / 8];
        ExtendedSecureRandom.nextBytes(keyBytes);
        if (mode.getRequiresInitVector() && (this.getIv() == null || this.getIv().length != 16)) {
            this.setIv(null);
        }
        SecretKeySpec aeskey = new SecretKeySpec(keyBytes, "AES");
        this.key = aeskey.getEncoded();
    }

    private void createCamellia(int keysize) {
        Mode mode = this.getMode();
        byte[] keyBytes = new byte[keysize / 8];
        ExtendedSecureRandom.nextBytes(keyBytes);
        if (mode.getRequiresInitVector()) {
            this.setIv(null);
        }
        SecretKeySpec camelliakey = new SecretKeySpec(keyBytes, "Camellia");
        this.key = camelliakey.getEncoded();
    }

    private void createTwofish(int keysize) {
        Mode mode = this.getMode();
        byte[] keyBytes = new byte[keysize / 8];
        ExtendedSecureRandom.nextBytes(keyBytes);
        if (mode.getRequiresInitVector()) {
            this.setIv(null);
        }
        SecretKeySpec twofishkey = new SecretKeySpec(keyBytes, "Twofish");
        this.key = twofishkey.getEncoded();
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.setIv(this.getIv());
        try {
            return Cipher.getInstance(this.getAlgorithm().getAlgorithmFamily().toUpperCase() + "/" + String.valueOf((Object)this.getMode()) + "/" + String.valueOf(this.getPadding()), this.getAlgorithm().getProvider());
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException("unknown provider", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] b) throws IOException {
        try {
            Cipher c = this.getCipher();
            SecretKeySpec ks = new SecretKeySpec(this.key, this.getAlgorithm().getAlgorithmFamily().toUpperCase());
            if (this.getMode().getRequiresInitVector()) {
                this.setIv(this.getIv());
                c.init(1, (java.security.Key)ks, new IvParameterSpec(this.getIv()));
            } else {
                c.init(1, ks);
            }
            return c.doFinal(b);
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Exception while encrypting", e);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Exception while init of cipher [possible limmited JCE installed] (" + String.valueOf(this.getParameter()) + "/" + this.getIv().length + "/" + this.key.length * 8 + ")", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("Exception while encrypting (" + this.getAlgorithm().getAlgorithmFamily() + "/" + this.getIv().length + ")", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] b) throws IOException {
        try {
            Cipher c = this.getCipher();
            SecretKeySpec ks = new SecretKeySpec(this.key, this.getAlgorithm().getAlgorithmFamily().toUpperCase());
            if (this.getMode().getRequiresInitVector()) {
                c.init(2, (java.security.Key)ks, new IvParameterSpec(this.getIv()));
            } else {
                c.init(2, ks);
            }
            return c.doFinal(b);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Exception while decrypting", e);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Exception while init of cipher", e);
        }
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        int i = 0;
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)to);
        this.parseKeyParameter(ASN1Sequence.getInstance((Object)s1.getObjectAt(i++)));
        this.key = ASN1OctetString.getInstance((Object)s1.getObjectAt(i)).getOctets();
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public byte[] setKey(byte[] b) {
        byte[] old = this.key;
        this.key = Arrays.copyOf(b, b.length);
        return old;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        ASN1EncodableVector ret = new ASN1EncodableVector();
        ret.add(this.encodeKeyParameter(dumpType));
        ret.add((ASN1Encodable)new DEROctetString(this.key));
        return new DERSequence(ret);
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t.getClass() != this.getClass()) {
            return false;
        }
        SymmetricKey o = (SymmetricKey)t;
        return o.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).equals(this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
    }

    public int hashCode() {
        return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).hashCode();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(this.dumpKeyTypeValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        sb.append(prefix).append("  key ").append(SymmetricKey.toHex(this.key)).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public String toString() {
        return "([SymmetricKey]hash=" + String.valueOf(this.key != null ? Integer.valueOf(Arrays.hashCode(this.key)) : "null") + ";" + String.valueOf(this.parameters) + ")";
    }
}

