/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.event.AbstractUninstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class RegistryUninstallerListener
extends AbstractUninstallerListener {
    private final RegistryHandler handler;
    private final Resources resources;
    private final Messages messages;
    private List actions;

    public RegistryUninstallerListener(RegistryDefaultHandler handler, Resources resources, Messages messages) {
        this.handler = handler.getInstance();
        this.resources = resources;
        this.messages = messages;
    }

    @Override
    public void initialise() {
        try {
            InputStream in = this.resources.getInputStream("registryEntries");
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.actions = (List)objIn.readObject();
            objIn.close();
            in.close();
        }
        catch (ResourceNotFoundException in) {
        }
        catch (Exception exception) {
            throw new IzPackException(exception);
        }
    }

    @Override
    public void beforeDelete(List<File> files, ProgressListener listener) {
        if (this.actions == null || this.actions.isEmpty()) {
            return;
        }
        if (this.handler != null) {
            try {
                this.handler.activateLogging();
                this.handler.setLoggingInfo(this.actions);
                this.handler.rewind();
            }
            catch (NativeLibException e) {
                throw new WrappedNativeLibException((Throwable)e, this.messages);
            }
        }
    }
}

