/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.branch;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitCurrentBranchConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitBranchCommand
extends AbstractBranchCommand
implements GitCommand {
    public ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, String message) throws ScmException {
        Commandline clPush;
        CommandLineUtils.StringStreamConsumer stderr;
        CommandLineUtils.StringStreamConsumer stdout;
        if (branch == null || branch.trim().isEmpty()) {
            throw new ScmException("branch name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support branching subsets of a directory");
        }
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        Commandline cl = GitBranchCommand.createCommandLine(repository, fileSet.getBasedir(), branch);
        int exitCode = GitCommandLineUtils.execute(cl, stdout = new CommandLineUtils.StringStreamConsumer(), stderr = new CommandLineUtils.StringStreamConsumer());
        if (exitCode != 0) {
            return new BranchScmResult(cl.toString(), "The git-branch command failed.", stderr.getOutput(), false);
        }
        if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(clPush = GitBranchCommand.createPushCommandLine(repository, fileSet, branch), stdout, stderr)) != 0) {
            return new BranchScmResult(clPush.toString(), "The git-push command failed.", stderr.getOutput(), false);
        }
        GitListConsumer listConsumer = new GitListConsumer(fileSet.getBasedir(), ScmFileStatus.TAGGED);
        Commandline clList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute(clList, (StreamConsumer)listConsumer, stderr);
        if (exitCode != 0) {
            return new BranchScmResult(clList.toString(), "The git-ls-files command failed.", stderr.getOutput(), false);
        }
        return new BranchScmResult(cl.toString(), listConsumer.getListedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, String branch) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "branch");
        cl.createArg().setValue(branch);
        return cl;
    }

    public static Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, String branch) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push");
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/heads/" + branch);
        return cl;
    }

    public static String getCurrentBranch(GitScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "symbolic-ref");
        cl.createArg().setValue("HEAD");
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        GitCurrentBranchConsumer cbConsumer = new GitCurrentBranchConsumer();
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)cbConsumer, stderr);
        if (exitCode != 0) {
            throw new ScmException("Detecting the current branch failed: " + stderr.getOutput());
        }
        return cbConsumer.getBranchName();
    }
}

