/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MessageVortexLogger
extends Logger {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final Handler consoleHandler = new ConsoleHandler();
    private static int init = 0;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = lock;
        synchronized (object) {
            if (init == 0) {
                init = 1;
                Handler[] handlers = MessageVortexLogger.getGlobalLogger().getParent().getHandlers();
                if (handlers != null) {
                    for (Handler h : handlers) {
                        MessageVortexLogger.getGlobalLogger().getParent().removeHandler(h);
                    }
                }
                consoleHandler.setFormatter(new MyLogFormatter());
                MessageVortexLogger.getGlobalLogger().getParent().addHandler(consoleHandler);
                MessageVortexLogger.getGlobalLogger().log(Level.INFO, "log level is set to " + String.valueOf(MessageVortexLogger.getGlobalLogLevel()));
                init = 2;
                MessageVortexLogger.getLogger("Logger").log(Level.INFO, "Logger initialized");
            }
        }
    }

    private MessageVortexLogger() {
        super(null, null);
        MessageVortexLogger.init();
    }

    public static void setGlobalLogLevel(Level l) {
        MessageVortexLogger.init();
        consoleHandler.setLevel(l);
        MessageVortexLogger.getGlobalLogger().getParent().setLevel(l);
    }

    public static Level getGlobalLogLevel() {
        MessageVortexLogger.init();
        return MessageVortexLogger.getGlobalLogger().getParent().getLevel();
    }

    public static Logger getGlobalLogger() {
        MessageVortexLogger.init();
        return LogManager.getLogManager().getLogger("global");
    }

    public static Logger getLogger(String name) {
        MessageVortexLogger.init();
        MessageVortexLogger.getGlobalLogger();
        return Logger.getLogger("global");
    }

    public static void flush() {
        MessageVortexLogger.init();
        consoleHandler.flush();
    }

    static {
        MessageVortexLogger.init();
    }

    static final class MyLogFormatter
    extends Formatter {
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        MyLogFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            try {
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    String time = sdf.format(new Date());
                    sb.append(time).append(' ').append(record.getLevel().getLocalizedName()).append(": ").append('[').append(Thread.currentThread().getName()).append('/').append(record.getLoggerName()).append("] ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
                }
                if (record.getThrown() != null) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        sb.append(sw);
                    }
                    catch (Exception sw) {}
                }
            }
            catch (Exception e) {
                System.err.println("DESASTER: exception while logging");
                e.printStackTrace();
                System.exit(200);
            }
            return sb.toString();
        }
    }
}

