/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.RunningDaemon;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.commandline.CommandLineHandlerIdentityStoreCreate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import picocli.CommandLine;

@CommandLine.Command(description={"Manipulator for IdentityStore"}, name="intentitystore", aliases={"store", "is"}, subcommands={CommandLineHandlerIdentityStoreCreate.class})
public class IdentityStore
extends AbstractBlock
implements Serializable,
Callable<Integer>,
RunningDaemon {
    public static final long serialVersionUID = 100000000008L;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static IdentityStore demo = null;
    private AsymmetricKey hostIdentity = null;
    private final Map<String, IdentityStoreBlock> blocks = new TreeMap<String, IdentityStoreBlock>();

    public IdentityStore() {
        this.blocks.clear();
    }

    public IdentityStore(byte[] b) throws IOException {
        this();
        this.parse(b);
    }

    public IdentityStore(File f) throws IOException {
        this();
        Path asn1DataPath = Paths.get(f.getAbsolutePath(), new String[0]);
        byte[] p = Files.readAllBytes(asn1DataPath);
        this.parse(p);
    }

    public static void resetDemo() {
        demo = null;
    }

    public static synchronized IdentityStore getIdentityStoreDemo() throws IOException {
        if (demo == null) {
            demo = IdentityStore.getNewIdentityStoreDemo(true);
        }
        return demo;
    }

    public static IdentityStore getNewIdentityStoreDemo(boolean complete) throws IOException {
        int i;
        IdentityStore tmp = new IdentityStore();
        tmp.add(IdentityStoreBlock.getIdentityStoreBlockDemo(IdentityStoreBlock.IdentityType.OWNED_IDENTITY, "user1@localhost", complete));
        for (i = 0; i < 10; ++i) {
            tmp.add(IdentityStoreBlock.getIdentityStoreBlockDemo(IdentityStoreBlock.IdentityType.NODE_IDENTITY, "dummy" + i + "@localhost", complete));
        }
        for (i = 1; i < 10; ++i) {
            tmp.add(IdentityStoreBlock.getIdentityStoreBlockDemo(IdentityStoreBlock.IdentityType.RECIPIENT_IDENTITY, "user" + i + "@localhost", complete));
        }
        return tmp;
    }

    public AsymmetricKey getHostIdentity() {
        return this.hostIdentity;
    }

    public AsymmetricKey setHostIdentity(AsymmetricKey identity) {
        AsymmetricKey ret = this.hostIdentity;
        this.hostIdentity = identity;
        return ret;
    }

    public String[] getIdentityList() {
        return this.blocks.keySet().toArray(new String[0]);
    }

    public Set<IdentityStoreBlock> getAnonSet(int size) throws IOException {
        LOGGER.log(Level.INFO, "Executing getAnonSet(" + size + ") from " + this.blocks.size());
        if (size > this.blocks.size() + 1) {
            return null;
        }
        HashSet<IdentityStoreBlock> ret = new HashSet<IdentityStoreBlock>();
        String[] keys = this.blocks.keySet().toArray(new String[0]);
        for (int i = 0; ret.size() < size && i < 10000; ++i) {
            IdentityStoreBlock isb = this.blocks.get(keys[ExtendedSecureRandom.nextInt(keys.length)]);
            if (!(isb == null || isb.getType() != IdentityStoreBlock.IdentityType.RECIPIENT_IDENTITY && isb.getType() != IdentityStoreBlock.IdentityType.NODE_IDENTITY || ret.contains(isb))) {
                ret.add(isb);
                LOGGER.log(Level.FINER, "adding to anonSet " + isb.getNodeAddress());
                continue;
            }
            if (isb != null) {
                LOGGER.log(Level.INFO, "Skipping " + isb.getNodeAddress() + " (" + String.valueOf((Object)isb.getType()) + ")");
                continue;
            }
            LOGGER.log(Level.SEVERE, "Skipping ISB==null");
        }
        if (ret.size() < size) {
            throw new IOException("unable to get anon set (size " + size + " too big; achieved: " + ret.size() + ")?");
        }
        LOGGER.log(Level.FINE, "done getAnonSet()");
        return ret;
    }

    @Override
    protected final void parse(byte[] p) throws IOException {
        try (ASN1InputStream aIn = new ASN1InputStream(p);){
            this.parse((ASN1Encodable)aIn.readObject());
        }
    }

    @Override
    protected final void parse(ASN1Encodable p) throws IOException {
        LOGGER.log(Level.FINER, "Executing parse()");
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)p);
        for (ASN1Encodable ao : s1.toArray()) {
            IdentityStoreBlock sb = new IdentityStoreBlock(ao);
            this.add(sb);
        }
        LOGGER.log(Level.FINER, "Finished parse()");
    }

    public void add(IdentityStoreBlock isb) {
        String ident = "";
        if (isb.getIdentityKey() != null) {
            ident = IdentityStore.toHex(isb.getIdentityKey().getPublicKey());
        }
        this.blocks.put(ident, isb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddress(String nodeAddress) throws IOException {
        ArrayList<String> rem = new ArrayList<String>();
        if (nodeAddress != null) {
            nodeAddress = nodeAddress.toLowerCase();
        }
        Map<String, IdentityStoreBlock> map = this.blocks;
        synchronized (map) {
            for (Map.Entry<String, IdentityStoreBlock> e : this.blocks.entrySet()) {
                String v = e.getValue().getNodeAddress();
                if ((v != null || nodeAddress != null) && (v == null || !v.toLowerCase().equals(nodeAddress))) continue;
                rem.add(e.getKey());
            }
            if (rem.size() == 0) {
                throw new IOException("unable to find nodeAddress \"" + nodeAddress + "\"");
            }
            for (String s : rem) {
                this.blocks.remove(s);
            }
        }
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        LOGGER.log(Level.FINER, "Executing toAsn1Object()");
        ASN1EncodableVector v = new ASN1EncodableVector();
        LOGGER.log(Level.FINER, "adding blocks");
        for (Map.Entry<String, IdentityStoreBlock> e : this.blocks.entrySet()) {
            v.add((ASN1Encodable)e.getValue().toAsn1Object(dumpType));
        }
        DERSequence seq = new DERSequence(v);
        LOGGER.log(Level.FINER, "done toAsn1Object()");
        return seq;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("i IdentityStore ::= {").append("\r\n");
        sb.append(prefix).append("  identities {").append("\r\n");
        int i = 0;
        for (Map.Entry<String, IdentityStoreBlock> e : this.blocks.entrySet()) {
            if (i > 0) {
                sb.append(',').append("\r\n");
            }
            sb.append(prefix).append("    -- Dumping IdentityBlock ").append(e.getKey()).append("\r\n");
            sb.append(prefix).append("    ").append(e.getValue().dumpValueNotation(prefix + "    ", dumpType));
            ++i;
        }
        sb.append("\r\n");
        sb.append(prefix).append("  }").append("\r\n");
        sb.append(prefix).append('}').append("\r\n");
        return sb.toString();
    }

    public IdentityStoreBlock getIdentity(String id) {
        return this.blocks.get(id);
    }

    @Override
    public Integer call() {
        return null;
    }

    @Override
    public void startDaemon() {
    }

    @Override
    public void stopDaemon() {
    }

    @Override
    public void shutdownDaemon() {
    }
}

