/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.AbstractConnection;
import net.messagevortex.transport.AuthenticationProxy;
import net.messagevortex.transport.ServerConnection;
import net.messagevortex.transport.StoppableThread;
import net.messagevortex.transport.imap.ImapBlankLineException;
import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapCommandFactory;
import net.messagevortex.transport.imap.ImapConnectionState;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;

public class ImapConnection
extends ServerConnection
implements Comparable<ImapConnection> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final int id = 1;
    private ImapConnectionState status = ImapConnectionState.CONNECTION_NOT_AUTHENTICATED;
    private AuthenticationProxy authProxy = null;
    private volatile ImapConnectionRunner imapConnectionRunner = null;

    public ImapConnection(AbstractConnection ac, AuthenticationProxy proxy) {
        super(ac);
        this.setAuth(proxy);
        this.init();
    }

    private void init() {
        this.imapConnectionRunner = new ImapConnectionRunner();
        this.setId(Thread.currentThread().getName() + "-conn1");
        this.imapConnectionRunner.start();
    }

    public final AuthenticationProxy setAuth(AuthenticationProxy authProxy) {
        AuthenticationProxy oldProxyAuth = this.getAuth();
        this.authProxy = authProxy;
        if (authProxy != null) {
            this.authProxy.setImapConnection(this);
        }
        return oldProxyAuth;
    }

    public AuthenticationProxy getAuth() {
        return this.authProxy;
    }

    public void setId(String id) {
        if (this.imapConnectionRunner != null) {
            this.imapConnectionRunner.setName(id);
        }
    }

    public ImapConnectionState setImapState(ImapConnectionState status) {
        ImapConnectionState old = this.status;
        this.status = status;
        return old;
    }

    public ImapConnectionState getImapState() {
        return this.status;
    }

    @Override
    public int compareTo(ImapConnection i) {
        return Integer.compare(this.hashCode(), i.hashCode());
    }

    public boolean equals(Object i) {
        return this == i;
    }

    public int hashCode() {
        return super.hashCode() + 1;
    }

    private String[] processCommand(String command) throws ImapException {
        ImapLine il = null;
        try {
            il = new ImapLine(this, command);
        }
        catch (ImapBlankLineException ie) {
            LOGGER.log(Level.INFO, "got a blank line as command", ie);
            return new String[]{"* BAD empty line"};
        }
        catch (ImapException ie) {
            LOGGER.log(Level.WARNING, "got invalid line", ie);
            return new String[]{"* BAD invalid line"};
        }
        LOGGER.log(Level.INFO, "got command \"" + il.getTag() + " " + il.getCommand() + "\".");
        ImapCommand c = ImapCommandFactory.getCommand(il.getCommand());
        if (c == null) {
            throw new ImapException(il, "Command \"" + il.getCommand() + "\" is not implemented");
        }
        LOGGER.log(Level.FINEST, "found command in connection " + Thread.currentThread().getName() + ".");
        String[] s = c.processCommand(il);
        LOGGER.log(Level.INFO, "got command \"" + il.getTag() + " " + il.getCommand() + "\". Reply is \"" + ImapLine.commandEncoder(s == null ? "null" : s[s.length - 1]) + "\" (" + String.valueOf(s != null ? Integer.valueOf(s.length) : "Null") + ").");
        return s;
    }

    @Override
    public void shutdown() {
        boolean conRunner = false;
        if (this.imapConnectionRunner != null) {
            conRunner = true;
            String rname = this.imapConnectionRunner.getName();
            ImapConnectionRunner icr = this.imapConnectionRunner;
            this.imapConnectionRunner = null;
            LOGGER.log(Level.INFO, "shut down for connection " + rname + " runner called");
            try {
                icr.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.log(Level.INFO, "shut down of abstract connection of " + rname + " called");
            try {
                super.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.log(Level.INFO, "waiting for shutdown of " + rname + " runner");
            icr.waitForShutdown();
            LOGGER.log(Level.INFO, "shut down connection " + rname + " completed");
        }
    }

    private class ImapConnectionRunner
    extends Thread
    implements StoppableThread {
        private volatile boolean shutdownImapRunner = false;

        private ImapConnectionRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdownImapRunner && ImapConnection.this.imapConnectionRunner != null) {
                    try {
                        String line = ImapConnection.this.readln();
                        if (line == null) {
                            this.shutdownImapRunner = true;
                            ImapConnection.this.getSocketChannel().close();
                            ImapConnection.this.imapConnectionRunner = null;
                            continue;
                        }
                        LOGGER.log(Level.INFO, "processing command \"" + ImapLine.commandEncoder(line) + "\"");
                        String[] reply = ImapConnection.this.processCommand(line + "\r\n");
                        if (reply != null) {
                            for (String r : reply) {
                                LOGGER.log(Level.INFO, "sending reply to client \"" + ImapLine.commandEncoder(r) + "\"");
                                if (r == null) continue;
                                ImapConnection.this.write(r);
                            }
                        }
                        if (reply != null && reply[reply.length - 1] != null) continue;
                        this.shutdownImapRunner = true;
                        ImapConnection.this.getSocketChannel().close();
                        ImapConnection.this.imapConnectionRunner = null;
                    }
                    catch (TimeoutException te) {
                        LOGGER.log(Level.WARNING, "got timeout exception when reading", te);
                    }
                }
                LOGGER.log(Level.INFO, "left main loop (shutting down)");
            }
            catch (IOException | ImapException ioe) {
                LOGGER.log(Level.WARNING, "got exception while waiting for lines (" + this.shutdownImapRunner + ")", ioe);
            }
            ImapConnection.this.imapConnectionRunner = null;
            this.shutdownImapRunner = true;
            LOGGER.log(Level.INFO, "shutdown of runner completed");
        }

        @Override
        public void shutdown() throws IOException {
            if (!this.shutdownImapRunner) {
                throw new IOException("No Imap runner running");
            }
            this.shutdownImapRunner = true;
        }

        @Override
        public boolean isShutdown() {
            return !this.isAlive() && this.shutdownImapRunner;
        }

        public void waitForShutdown() {
            while (!this.isShutdown() && Thread.currentThread() != this) {
                try {
                    this.join(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

