/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.DeclarativeConfigUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;

public abstract class AbstractConfigLocator {
    private static final ILogger LOGGER = Logger.getLogger(AbstractConfigLocator.class);
    private InputStream in;
    private File configurationFile;
    private URL configurationUrl;

    public InputStream getIn() {
        return this.in;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public boolean isConfigPresent() {
        return this.in != null || this.configurationFile != null || this.configurationUrl != null;
    }

    public abstract boolean locateFromSystemProperty();

    protected abstract boolean locateFromSystemPropertyOrFailOnUnacceptedSuffix();

    protected abstract boolean locateInWorkDir();

    protected abstract boolean locateOnClasspath();

    public abstract boolean locateDefault();

    public boolean locateEverywhere() {
        return this.locateFromSystemPropertyOrFailOnUnacceptedSuffix() || this.locateInWorkDir() || this.locateOnClasspath() || this.locateDefault();
    }

    public boolean locateInWorkDirOrOnClasspath() {
        return this.locateInWorkDir() || this.locateOnClasspath();
    }

    protected void loadDefaultConfigurationFromClasspath(String defaultConfigFile) {
        try {
            LOGGER.info(String.format("Loading '%s' from the classpath.", defaultConfigFile));
            this.configurationUrl = Config.class.getClassLoader().getResource(defaultConfigFile);
            if (this.configurationUrl == null) {
                throw new HazelcastException(String.format("Could not find '%s' in the classpath! This may be due to a wrong-packaged or corrupted jar file.", defaultConfigFile));
            }
            this.in = Config.class.getClassLoader().getResourceAsStream(defaultConfigFile);
            if (this.in == null) {
                throw new HazelcastException(String.format("Could not load '%s' from the classpath", defaultConfigFile));
            }
        }
        catch (RuntimeException e) {
            throw new HazelcastException(e);
        }
    }

    protected boolean loadConfigurationFromClasspath(String configFileName) {
        try {
            URL url = this.resolveResourceUrl(configFileName);
            if (url == null) {
                LOGGER.finest(String.format("Could not find '%s' in the classpath.", configFileName));
                return false;
            }
            LOGGER.info(String.format("Loading '%s' from the classpath.", configFileName));
            this.configurationUrl = url;
            this.in = this.resolveResourceAsStream(configFileName);
            if (this.in == null) {
                throw new HazelcastException(String.format("Could not load '%s' from the classpath", configFileName));
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new HazelcastException(e);
        }
    }

    protected boolean loadConfigurationFromClasspath(String configFilePrefix, Collection<String> acceptedSuffixes) {
        Objects.requireNonNull(acceptedSuffixes, "Parameter acceptedSuffixes must not be null");
        Preconditions.checkFalse(acceptedSuffixes.isEmpty(), "Parameter acceptedSuffixes must not be empty");
        for (String suffix : acceptedSuffixes) {
            Objects.requireNonNull(suffix, "Parameter acceptedSuffixes must not contain nulls");
            Preconditions.checkFalse(suffix.isEmpty(), "Parameter acceptedSuffixes must not contain empty strings");
            if (!this.loadConfigurationFromClasspath(configFilePrefix + "." + suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadFromWorkingDirectory(String configFilePath) {
        try {
            File file = new File(configFilePath);
            if (!file.exists()) {
                LOGGER.finest(String.format("Could not find '%s' in the working directory.", configFilePath));
                return false;
            }
            LOGGER.info(String.format("Loading '%s' from the working directory.", configFilePath));
            this.configurationFile = file;
            try {
                this.in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new HazelcastException(String.format("Failed to open file: %s", file.getAbsolutePath()), e);
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new HazelcastException(e);
        }
    }

    protected boolean loadFromWorkingDirectory(String configFilePrefix, Collection<String> acceptedSuffixes) {
        Objects.requireNonNull(acceptedSuffixes, "Parameter acceptedSuffixes must not be null");
        Preconditions.checkFalse(acceptedSuffixes.isEmpty(), "Parameter acceptedSuffixes must not be empty");
        for (String suffix : acceptedSuffixes) {
            Objects.requireNonNull(suffix, "Parameter acceptedSuffixes must not contain nulls");
            Preconditions.checkFalse(suffix.isEmpty(), "Parameter acceptedSuffixes must not contain empty strings");
            if (!this.loadFromWorkingDirectory(configFilePrefix + "." + suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadFromSystemProperty(String propertyKey, Collection<String> acceptedSuffixes) {
        return this.loadFromSystemProperty(propertyKey, false, acceptedSuffixes);
    }

    protected boolean loadFromSystemPropertyOrFailOnUnacceptedSuffix(String propertyKey, Collection<String> acceptedSuffixes) {
        return this.loadFromSystemProperty(propertyKey, true, acceptedSuffixes);
    }

    private boolean loadFromSystemProperty(String propertyKey, boolean failOnUnacceptedSuffix, Collection<String> acceptedSuffixes) {
        Objects.requireNonNull(acceptedSuffixes, "Parameter acceptedSuffixes must not be null");
        Preconditions.checkFalse(acceptedSuffixes.isEmpty(), "Parameter acceptedSuffixes must not be empty");
        try {
            String configSystemProperty = System.getProperty(propertyKey);
            if (configSystemProperty == null) {
                LOGGER.finest(String.format("Could not find '%s' System property", propertyKey));
                return false;
            }
            if (!DeclarativeConfigUtil.isAcceptedSuffixConfigured(configSystemProperty, acceptedSuffixes)) {
                if (failOnUnacceptedSuffix) {
                    DeclarativeConfigUtil.throwUnacceptedSuffixInSystemProperty(propertyKey, configSystemProperty, acceptedSuffixes);
                } else {
                    return false;
                }
            }
            LOGGER.info(String.format("Loading configuration '%s' from System property '%s'", configSystemProperty, propertyKey));
            if (configSystemProperty.startsWith("classpath:")) {
                this.loadSystemPropertyClassPathResource(configSystemProperty);
            } else {
                this.loadSystemPropertyFileResource(configSystemProperty);
            }
            return true;
        }
        catch (HazelcastException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new HazelcastException(e);
        }
    }

    private void loadSystemPropertyFileResource(String configSystemProperty) {
        this.configurationFile = new File(configSystemProperty);
        LOGGER.info(String.format("Using configuration file at %s", this.configurationFile.getAbsolutePath()));
        if (!this.configurationFile.exists()) {
            String msg = String.format("Config file at '%s' doesn't exist.", this.configurationFile.getAbsolutePath());
            throw new HazelcastException(msg);
        }
        try {
            this.in = new FileInputStream(this.configurationFile);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException(String.format("Failed to open file: %s", this.configurationFile.getAbsolutePath()), e);
        }
        try {
            this.configurationUrl = this.configurationFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new HazelcastException(String.format("Failed to create URL from the file: %s", this.configurationFile.getAbsolutePath()), e);
        }
    }

    private void loadSystemPropertyClassPathResource(String configSystemProperty) {
        String resource = configSystemProperty.substring("classpath:".length());
        LOGGER.info(String.format("Using classpath resource at %s", resource));
        if (resource.isEmpty()) {
            throw new HazelcastException("classpath resource can't be empty");
        }
        this.in = this.resolveResourceAsStream(resource);
        if (this.in == null) {
            throw new HazelcastException(String.format("Could not load classpath resource: %s", resource));
        }
        this.configurationUrl = this.resolveResourceUrl(resource);
    }

    private URL resolveResourceUrl(String configFileName) {
        URL resource = Config.class.getClassLoader().getResource(configFileName);
        return resource != null ? resource : Thread.currentThread().getContextClassLoader().getResource(configFileName);
    }

    private InputStream resolveResourceAsStream(String configFileName) {
        InputStream resource = Config.class.getClassLoader().getResourceAsStream(configFileName);
        return resource != null ? resource : Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);
    }
}

