/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MetricDescriptorImpl
implements MetricDescriptor {
    private static final int INITIAL_TAG_CAPACITY = 4;
    private static final double GROW_FACTOR = 1.2;
    private static final int INITIAL_STRING_CAPACITY = 64;
    private final LookupView lookupView = new LookupView();
    private Supplier<MetricDescriptorImpl> supplier;
    private String[] tags;
    private int tagPtr;
    private String prefix;
    private String metric;
    private String discriminator;
    private String discriminatorValue;
    private ProbeUnit unit;
    private Collection<MetricTarget> excludedTargets = MetricTarget.NONE_OF;

    public MetricDescriptorImpl(Supplier<MetricDescriptorImpl> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
        this.tags = new String[8];
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withTag(String tag, String value) {
        this.ensureCapacity(this.tagPtr);
        this.tags[this.tagPtr] = Objects.requireNonNull(tag);
        this.tags[this.tagPtr + 1] = Objects.requireNonNull(value);
        this.tagPtr += 2;
        return this;
    }

    @Override
    @Nullable
    public String tagValue(String tag) {
        Objects.requireNonNull(tag);
        for (int i2 = 0; i2 < this.tagPtr; i2 += 2) {
            String tagStored = this.tags[i2];
            String tagValue = this.tags[i2 + 1];
            if (!tag.equals(tagStored)) continue;
            return tagValue;
        }
        return null;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withDiscriminator(String discriminatorTag, String discriminatorValue) {
        this.discriminator = discriminatorTag;
        this.discriminatorValue = discriminatorValue;
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withUnit(ProbeUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl copy() {
        MetricDescriptorImpl copy = this.supplier.get();
        copy.prefix = this.prefix;
        copy.metric = this.metric;
        copy.discriminator = this.discriminator;
        copy.discriminatorValue = this.discriminatorValue;
        copy.unit = this.unit;
        copy.excludedTargets = this.excludedTargets;
        copy.ensureCapacity(this.tagCount() << 1);
        this.readTags(copy::withTag);
        return copy;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl copy(MetricDescriptor descriptor) {
        this.reset();
        this.prefix = descriptor.prefix();
        this.metric = descriptor.metric();
        this.discriminator = descriptor.discriminator();
        this.discriminatorValue = descriptor.discriminatorValue();
        this.unit = descriptor.unit();
        this.excludedTargets = descriptor.excludedTargets();
        this.ensureCapacity(descriptor.tagCount() << 1);
        descriptor.readTags(this::withTag);
        return this;
    }

    @Override
    @Nullable
    public String prefix() {
        return this.prefix;
    }

    @Override
    public String metric() {
        return this.metric;
    }

    @Override
    @Nullable
    public String discriminator() {
        return this.discriminator;
    }

    @Override
    @Nullable
    public String discriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    @Nullable
    public ProbeUnit unit() {
        return this.unit;
    }

    @Override
    public int tagCount() {
        return this.tagPtr >> 1;
    }

    @Override
    public void readTags(BiConsumer<String, String> tagReader) {
        for (int i2 = 0; i2 < this.tagPtr; i2 += 2) {
            String tag = this.tags[i2];
            String tagValue = this.tags[i2 + 1];
            tagReader.accept(tag, tagValue);
        }
    }

    @Override
    public String tag(int index) {
        if ((index <<= 1) < 0 || index >= this.tagPtr) {
            throw new IndexOutOfBoundsException();
        }
        return this.tags[index];
    }

    @Override
    public String tagValue(int index) {
        if ((index = (index << 1) + 1) < 0 || index >= this.tagPtr) {
            throw new IndexOutOfBoundsException();
        }
        return this.tags[index];
    }

    @Override
    @Nonnull
    public String metricString() {
        return this.buildMetricString(false);
    }

    private String buildMetricString(boolean includeExcludedTargets) {
        StringBuilder sb = new StringBuilder(64).append('[');
        if (this.discriminatorValue != null) {
            sb.append(this.discriminator).append('=').append(this.discriminatorValue).append(',');
        }
        if (this.unit != null) {
            sb.append("unit=").append(StringUtil.lowerCaseInternal(this.unit.name())).append(',');
        }
        if (this.metric != null) {
            sb.append("metric=");
            if (this.prefix != null) {
                sb.append(this.prefix).append('.');
            }
            sb.append(this.metric);
            sb.append(',');
        }
        for (int i2 = 0; i2 < this.tagPtr; i2 += 2) {
            String tag = this.tags[i2];
            String tagValue = this.tags[i2 + 1];
            sb.append(tag).append('=').append(tagValue).append(',');
        }
        if (includeExcludedTargets) {
            sb.append("excludedTargets={");
            if (this.excludedTargets.isEmpty()) {
                sb.append('}');
            } else {
                for (MetricTarget target : this.excludedTargets) {
                    sb.append(target.name()).append(',');
                }
                sb.setCharAt(sb.length() - 1, '}');
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public Collection<MetricTarget> excludedTargets() {
        return this.excludedTargets;
    }

    @Override
    public boolean isTargetExcluded(MetricTarget target) {
        return this.excludedTargets.contains((Object)target);
    }

    @Override
    public boolean isTargetIncluded(MetricTarget target) {
        return !this.isTargetExcluded(target);
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withExcludedTarget(MetricTarget target) {
        this.excludedTargets = MetricTarget.asSetWith(this.excludedTargets, target);
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withIncludedTarget(MetricTarget target) {
        this.excludedTargets = MetricTarget.asSetWithout(this.excludedTargets, target);
        return this;
    }

    @Override
    @Nonnull
    public MetricDescriptorImpl withExcludedTargets(Collection<MetricTarget> excludedTargets) {
        this.excludedTargets = excludedTargets;
        return this;
    }

    LookupView lookupView() {
        return this.lookupView;
    }

    private void ensureCapacity(int tagPtr) {
        if (tagPtr < this.tags.length) {
            return;
        }
        int newCapacity = (int)Math.max((double)tagPtr, Math.ceil((double)this.tags.length * 1.2));
        if (newCapacity % 2 != 0) {
            ++newCapacity;
        }
        String[] newTags = new String[newCapacity];
        System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
        this.tags = newTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDescriptorImpl that = (MetricDescriptorImpl)o;
        if (this.tagPtr != that.tagPtr) {
            return false;
        }
        if (this.unit != that.unit) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.metric, that.metric)) {
            return false;
        }
        if (!Objects.equals(this.discriminatorValue, that.discriminatorValue)) {
            return false;
        }
        if (!Objects.equals(this.discriminator, that.discriminator)) {
            return false;
        }
        if (!Objects.equals(this.excludedTargets, that.excludedTargets)) {
            return false;
        }
        block0: for (int i2 = 0; i2 < this.tagPtr; i2 += 2) {
            String thisTag = this.tags[i2];
            String thisTagValue = this.tags[i2 + 1];
            for (int j = 0; j < that.tagPtr; j += 2) {
                String thatTag = that.tags[j];
                String thatTagValue = that.tags[j + 1];
                if (thisTag.equals(thatTag) && thisTagValue.equals(thatTagValue)) continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i2 = 0; i2 < this.tagPtr; i2 += 2) {
            String tag = this.tags[i2];
            String tagValue = this.tags[i2 + 1];
            result += tag.hashCode() + 31 * tagValue.hashCode();
        }
        result = 31 * result + this.tagPtr;
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
        result = 31 * result + (this.discriminator != null ? this.discriminator.hashCode() : 0);
        result = 31 * result + (this.discriminatorValue != null ? this.discriminatorValue.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + this.excludedTargets.hashCode();
        return result;
    }

    @Override
    @Nonnull
    public MetricDescriptor reset() {
        this.prefix = null;
        this.metric = null;
        this.unit = null;
        this.tagPtr = 0;
        this.discriminator = null;
        this.discriminatorValue = null;
        Arrays.fill(this.tags, null);
        return this;
    }

    void setSupplier(Supplier<MetricDescriptorImpl> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public String toString() {
        return this.buildMetricString(true);
    }

    public class LookupView {
        public MetricDescriptorImpl descriptor() {
            return MetricDescriptorImpl.this;
        }

        private String prefix() {
            return MetricDescriptorImpl.this.prefix;
        }

        private String metricName() {
            return MetricDescriptorImpl.this.metric;
        }

        private String discriminatorValue() {
            return MetricDescriptorImpl.this.discriminatorValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupView that = (LookupView)o;
            if (!Objects.equals(MetricDescriptorImpl.this.prefix, that.prefix())) {
                return false;
            }
            if (!Objects.equals(MetricDescriptorImpl.this.metric, that.metricName())) {
                return false;
            }
            return Objects.equals(MetricDescriptorImpl.this.discriminatorValue, that.discriminatorValue());
        }

        public int hashCode() {
            int result = MetricDescriptorImpl.this.prefix != null ? MetricDescriptorImpl.this.prefix.hashCode() : 0;
            result = 31 * result + (MetricDescriptorImpl.this.metric != null ? MetricDescriptorImpl.this.metric.hashCode() : 0);
            result = 31 * result + (MetricDescriptorImpl.this.discriminatorValue != null ? MetricDescriptorImpl.this.discriminatorValue.hashCode() : 0);
            result = 31 * result + (MetricDescriptorImpl.this.discriminatorValue != null ? MetricDescriptorImpl.this.discriminatorValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.metricName();
        }
    }
}

