/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.impl.MigrationPlanner;
import com.hazelcast.internal.partition.impl.MigrationQueue;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.partition.impl.MigrationStats;
import com.hazelcast.internal.partition.impl.MigrationThread;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.DemoteResponseOperation;
import com.hazelcast.internal.partition.operation.FinalizeMigrationOperation;
import com.hazelcast.internal.partition.operation.MigrationCommitOperation;
import com.hazelcast.internal.partition.operation.MigrationRequestOperation;
import com.hazelcast.internal.partition.operation.PromotionCommitOperation;
import com.hazelcast.internal.partition.operation.PublishCompletedMigrationsOperation;
import com.hazelcast.internal.partition.operation.ShutdownResponseOperation;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.internal.util.collection.IntHashSet;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class MigrationManagerImpl
implements MigrationManager {
    private static final int MIGRATION_PAUSE_DURATION_SECONDS_ON_MIGRATION_FAILURE = 3;
    private static final int PUBLISH_COMPLETED_MIGRATIONS_BATCH_SIZE = 10;
    private static final long CHECK_CLUSTER_PARTITION_RUNTIME_STATES_SYNC_TIMEOUT_SECONDS = 2L;
    private static final int COMMIT_SUCCESS = 1;
    private static final int COMMIT_RETRY = 0;
    private static final int COMMIT_FAILURE = -1;
    final long partitionMigrationInterval;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final ILogger logger;
    private final PartitionStateManager partitionStateManager;
    private final MigrationQueue migrationQueue = new MigrationQueue();
    private final MigrationThread migrationThread;
    private final AtomicBoolean migrationTasksAllowed = new AtomicBoolean(true);
    private final long partitionMigrationTimeout;
    private final CoalescingDelayedTrigger delayedResumeMigrationTrigger;
    private final Set<Member> shutdownRequestedMembers = new HashSet<Member>();
    private final Set<Member> demoteRequestedMembers = new HashSet<Member>();
    private final ConcurrentMap<Integer, MigrationInfo> activeMigrations = new ConcurrentHashMap<Integer, MigrationInfo>();
    private final LinkedHashSet<MigrationInfo> completedMigrations = new LinkedHashSet();
    private final AtomicBoolean promotionPermit = new AtomicBoolean(false);
    private final MigrationStats stats = new MigrationStats();
    private volatile MigrationInterceptor migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    private final Lock partitionServiceLock;
    private final MigrationPlanner migrationPlanner;
    private final boolean fragmentedMigrationEnabled;
    private final boolean chunkedMigrationEnabled;
    private final int maxTotalChunkedDataInBytes;
    private final long memberHeartbeatTimeoutMillis;
    private boolean triggerRepartitioningWhenClusterStateAllowsMigration;
    private final int maxParallelMigrations;
    private final AtomicInteger migrationCount = new AtomicInteger();
    private final Set<MigrationInfo> finalizingMigrationsRegistry = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Executor asyncExecutor;
    private final int autoRebalanceDelaySeconds;
    private volatile boolean delayNextRepartitioningExecution;
    private volatile ScheduledFuture<Void> scheduledControlTaskFuture;

    MigrationManagerImpl(Node node, InternalPartitionServiceImpl service, Lock partitionServiceLock) {
        this.node = node;
        this.nodeEngine = node.getNodeEngine();
        this.partitionService = service;
        this.logger = node.getLogger(this.getClass());
        this.partitionServiceLock = partitionServiceLock;
        this.migrationPlanner = new MigrationPlanner(node.getLogger(MigrationPlanner.class));
        HazelcastProperties properties = node.getProperties();
        this.partitionMigrationInterval = properties.getPositiveMillisOrDefault(ClusterProperty.PARTITION_MIGRATION_INTERVAL, 0L);
        this.partitionMigrationTimeout = properties.getMillis(ClusterProperty.PARTITION_MIGRATION_TIMEOUT);
        this.fragmentedMigrationEnabled = properties.getBoolean(ClusterProperty.PARTITION_FRAGMENTED_MIGRATION_ENABLED);
        this.chunkedMigrationEnabled = properties.getBoolean(ClusterProperty.PARTITION_CHUNKED_MIGRATION_ENABLED);
        this.maxTotalChunkedDataInBytes = (int)MemoryUnit.MEGABYTES.toBytes(properties.getInteger(ClusterProperty.PARTITION_CHUNKED_MAX_MIGRATING_DATA_IN_MB));
        this.maxParallelMigrations = properties.getInteger(ClusterProperty.PARTITION_MAX_PARALLEL_MIGRATIONS);
        this.partitionStateManager = this.partitionService.getPartitionStateManager();
        ILogger migrationThreadLogger = node.getLogger(MigrationThread.class);
        String hzName = this.nodeEngine.getHazelcastInstance().getName();
        this.migrationThread = new MigrationThread(this, hzName, migrationThreadLogger, this.migrationQueue);
        long migrationPauseDelayMs = TimeUnit.SECONDS.toMillis(3L);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        this.delayedResumeMigrationTrigger = new CoalescingDelayedTrigger(executionService, migrationPauseDelayMs, 2L * migrationPauseDelayMs, this::resumeMigration);
        this.memberHeartbeatTimeoutMillis = properties.getMillis(ClusterProperty.MAX_NO_HEARTBEAT_SECONDS);
        this.nodeEngine.getMetricsRegistry().registerStaticMetrics(this.stats, "partitions");
        this.autoRebalanceDelaySeconds = node.getConfig().getPersistenceConfig().isEnabled() ? node.getConfig().getPersistenceConfig().getRebalanceDelaySeconds() : 0;
        this.asyncExecutor = node.getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    @Override
    public long getPartitionMigrationInterval() {
        return this.partitionMigrationInterval;
    }

    @Probe(name="migrationActive", unit=ProbeUnit.BOOLEAN)
    private int migrationActiveProbe() {
        return this.migrationTasksAllowed.get() ? 1 : 0;
    }

    @Override
    public void pauseMigration() {
        this.migrationTasksAllowed.set(false);
    }

    @Override
    public void resumeMigration() {
        this.migrationTasksAllowed.set(true);
    }

    private void resumeMigrationEventually() {
        this.delayedResumeMigrationTrigger.executeWithDelay();
    }

    @Override
    public boolean areMigrationTasksAllowed() {
        return this.migrationTasksAllowed.get();
    }

    @Override
    public void finalizeMigration(MigrationInfo migrationInfo) {
        try {
            PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
            int partitionId = migrationInfo.getPartitionId();
            boolean source = localReplica.equals(migrationInfo.getSource());
            boolean destination = localReplica.equals(migrationInfo.getDestination());
            assert (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS || migrationInfo.getStatus() == MigrationInfo.MigrationStatus.FAILED) : "Invalid migration: " + migrationInfo;
            if (source || destination) {
                MigrationInterceptor.MigrationParticipant participant;
                boolean success = migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS;
                MigrationInterceptor.MigrationParticipant migrationParticipant = participant = source ? MigrationInterceptor.MigrationParticipant.SOURCE : MigrationInterceptor.MigrationParticipant.DESTINATION;
                if (success) {
                    this.migrationInterceptor.onMigrationCommit(participant, migrationInfo);
                } else {
                    this.migrationInterceptor.onMigrationRollback(participant, migrationInfo);
                }
                MigrationEndpoint endpoint = source ? MigrationEndpoint.SOURCE : MigrationEndpoint.DESTINATION;
                FinalizeMigrationOperation op = new FinalizeMigrationOperation(migrationInfo, endpoint, success);
                op.setPartitionId(partitionId).setNodeEngine(this.nodeEngine).setValidateTarget(false).setService(this.partitionService);
                this.registerFinalizingMigration(migrationInfo);
                OperationServiceImpl operationService = this.nodeEngine.getOperationService();
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Finalizing " + migrationInfo);
                }
                if (operationService.isRunAllowed(op)) {
                    operationService.run(op);
                } else {
                    operationService.execute(op);
                }
                this.removeActiveMigration(migrationInfo);
            } else {
                PartitionReplica partitionOwner = this.partitionStateManager.getPartitionImpl(partitionId).getOwnerReplicaOrNull();
                if (localReplica.equals(partitionOwner)) {
                    this.removeActiveMigration(migrationInfo);
                    this.partitionStateManager.clearMigratingFlag(partitionId);
                } else {
                    this.logger.severe("Failed to finalize migration because " + localReplica + " is not a participant of the migration: " + migrationInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
    }

    private void registerFinalizingMigration(MigrationInfo migration) {
        this.finalizingMigrationsRegistry.add(migration);
    }

    @Override
    public boolean isChunkedMigrationEnabled() {
        return this.chunkedMigrationEnabled;
    }

    @Override
    public int getMaxTotalChunkedDataInBytes() {
        return this.maxTotalChunkedDataInBytes;
    }

    @Override
    public boolean removeFinalizingMigration(MigrationInfo migration) {
        return this.finalizingMigrationsRegistry.remove(migration);
    }

    @Override
    public boolean isFinalizingMigrationRegistered(int partitionId) {
        return this.finalizingMigrationsRegistry.stream().anyMatch(m -> partitionId == m.getPartitionId());
    }

    @Override
    public MigrationInfo addActiveMigration(MigrationInfo migrationInfo) {
        return this.activeMigrations.putIfAbsent(migrationInfo.getPartitionId(), migrationInfo);
    }

    @Override
    public MigrationInfo getActiveMigration(int partitionId) {
        return (MigrationInfo)this.activeMigrations.get(partitionId);
    }

    @Override
    public Collection<MigrationInfo> getActiveMigrations() {
        return Collections.unmodifiableCollection(this.activeMigrations.values());
    }

    private boolean removeActiveMigration(MigrationInfo migration) {
        MigrationInfo activeMigration = this.activeMigrations.computeIfPresent(migration.getPartitionId(), (k, currentMigration) -> currentMigration.equals(migration) ? null : currentMigration);
        if (activeMigration != null) {
            this.logger.warning("Active migration could not be removed! Current migration=" + migration + ", active migration=" + activeMigration);
            return false;
        }
        return true;
    }

    @Override
    public boolean acquirePromotionPermit() {
        return this.promotionPermit.compareAndSet(false, true);
    }

    @Override
    public void releasePromotionPermit() {
        this.promotionPermit.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleActiveMigrationFinalization(MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            MigrationInfo activeMigrationInfo = this.getActiveMigration(migrationInfo.getPartitionId());
            if (migrationInfo.equals(activeMigrationInfo)) {
                activeMigrationInfo.setStatus(migrationInfo.getStatus());
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Scheduled finalization of " + activeMigrationInfo);
                }
                this.finalizeMigration(activeMigrationInfo);
                return;
            }
            PartitionReplica source = migrationInfo.getSource();
            if (source != null && migrationInfo.getSourceCurrentReplicaIndex() > 0 && source.isIdentical(this.node.getLocalMember())) {
                InternalPartitionImpl partition = this.partitionStateManager.getPartitionImpl(migrationInfo.getPartitionId());
                if (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getSourceNewReplicaIndex() != partition.getReplicaIndex(source)) {
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Already finalized " + migrationInfo + " on former backup replica. -> " + partition);
                    }
                    return;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Scheduled finalization of " + migrationInfo + " on former backup replica.");
                }
                this.finalizeMigration(migrationInfo);
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private CompletionStage<Boolean> commitMigrationToDestinationAsync(MigrationInfo migration) {
        PartitionReplica destination = migration.getDestination();
        if (destination.isIdentical(this.node.getLocalMember())) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Shortcutting migration commit, since destination is master. -> " + migration);
            }
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        MemberImpl member = this.node.getClusterService().getMember(destination.address(), destination.uuid());
        if (member == null) {
            this.logger.warning("Cannot commit " + migration + ". Destination " + destination + " is not a member anymore");
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Sending migration commit operation to " + destination + " for " + migration);
            }
            migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            UUID destinationUuid = member.getUuid();
            MigrationCommitOperation operation = new MigrationCommitOperation(migration, destinationUuid);
            InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(this.memberHeartbeatTimeoutMillis).invoke();
            return ((CompletableFuture)future.handleAsync((done, t) -> {
                this.logger.fine("Migration commit response received -> " + migration + ", success: " + done + ", failure: " + t);
                if (t != null) {
                    this.logMigrationCommitFailure(migration, (Throwable)t);
                    if (t instanceof OperationTimeoutException || t.getCause() instanceof OperationTimeoutException) {
                        return 0;
                    }
                    return -1;
                }
                return done != false ? 1 : -1;
            }, this.asyncExecutor).thenComposeAsync(result -> {
                switch (result) {
                    case 1: {
                        return CompletableFuture.completedFuture(true);
                    }
                    case -1: {
                        return CompletableFuture.completedFuture(false);
                    }
                    case 0: {
                        this.logger.fine("Retrying migration commit for -> " + migration);
                        return this.commitMigrationToDestinationAsync(migration);
                    }
                }
                throw new IllegalArgumentException("Unknown migration commit result: " + result);
            }, this.asyncExecutor)).handleAsync((result, t) -> {
                if (t != null) {
                    this.logMigrationCommitFailure(migration, (Throwable)t);
                    return false;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Migration commit result " + result + " from " + destination + " for " + migration);
                }
                return result;
            }, this.asyncExecutor);
        }
        catch (Throwable t2) {
            this.logMigrationCommitFailure(migration, t2);
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
    }

    private void logMigrationCommitFailure(MigrationInfo migration, Throwable t) {
        boolean memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
        PartitionReplica destination = migration.getDestination();
        if (memberLeft) {
            if (destination.isIdentical(this.node.getLocalMember())) {
                this.logger.fine("Migration commit failed for " + migration + " since this node is shutting down.");
                return;
            }
            this.logger.warning("Migration commit failed for " + migration + " since destination " + destination + " left the cluster");
        } else {
            this.logger.severe("Migration commit to " + destination + " failed for " + migration, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCompletedMigration(MigrationInfo migrationInfo) {
        if (migrationInfo.getStatus() != MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getStatus() != MigrationInfo.MigrationStatus.FAILED) {
            throw new IllegalArgumentException("Migration doesn't seem completed: " + migrationInfo);
        }
        if (migrationInfo.getInitialPartitionVersion() <= 0 || migrationInfo.getPartitionVersionIncrement() <= 0) {
            throw new IllegalArgumentException("Partition state versions are not set: " + migrationInfo);
        }
        this.partitionServiceLock.lock();
        try {
            boolean added = this.completedMigrations.add(migrationInfo);
            if (added) {
                this.stats.incrementCompletedMigrations();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public void retainCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.retainAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private void evictCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.removeAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public void triggerControlTask() {
        this.migrationQueue.clear();
        this.migrationThread.abortMigrationTask();
        if (this.stats.getRemainingMigrations() > 0) {
            this.migrationQueue.add(new PublishCompletedMigrationsTask());
        }
        if (!this.node.getClusterService().isJoined()) {
            this.logger.fine("Node is not joined, will not trigger ControlTask");
            return;
        }
        if (!this.partitionService.isLocalMemberMaster()) {
            this.logger.fine("Node is not master, will not trigger ControlTask");
            return;
        }
        this.migrationQueue.add(new ControlTask());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Migration queue is cleared and control task is scheduled");
        }
    }

    @Override
    public void triggerControlTaskWithDelay() {
        if (this.autoRebalanceDelaySeconds > 0) {
            this.delayNextRepartitioningExecution = true;
        }
        this.triggerControlTask();
    }

    @Override
    public MigrationInterceptor getMigrationInterceptor() {
        return this.migrationInterceptor;
    }

    @Override
    public void setMigrationInterceptor(MigrationInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor);
        this.migrationInterceptor = interceptor;
    }

    @Override
    public void resetMigrationInterceptor() {
        this.migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    }

    @Override
    public boolean onDemoteRequest(Member member) {
        if (this.node.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR) - this.getDataDisownRequestedMembers().size() <= 1) {
            this.logger.info("Demote is not possible because there would be no data member left after demotion");
            return false;
        }
        if (!this.partitionStateManager.isInitialized()) {
            if (this.demoteRequestedMembers.add(member)) {
                this.logger.info("Demote request of " + member + " is handled");
            }
            this.sendDemoteResponseOperation(member);
            return true;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed() && clusterState != ClusterState.IN_TRANSITION) {
            this.logger.info("Demote is not possible in cluster state " + clusterState);
            return false;
        }
        if (this.demoteRequestedMembers.add(member)) {
            this.logger.info("Demote request of " + member + " is handled");
            this.triggerControlTask();
        }
        return true;
    }

    @Override
    public void onShutdownRequest(Member member) {
        if (!this.partitionStateManager.isInitialized()) {
            this.sendShutdownResponseOperation(member);
            return;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed() && clusterState != ClusterState.IN_TRANSITION) {
            this.sendShutdownResponseOperation(member);
            return;
        }
        if (this.shutdownRequestedMembers.add(member)) {
            this.logger.info("Shutdown request of " + member + " is handled");
            this.triggerControlTask();
        }
    }

    @Override
    public void onMemberRemove(Member member) {
        this.shutdownRequestedMembers.remove(member);
        this.demoteRequestedMembers.remove(member);
    }

    @Override
    public void schedule(MigrationRunnable runnable) {
        this.migrationQueue.add(runnable);
    }

    @Override
    public List<MigrationInfo> getCompletedMigrationsCopy() {
        this.partitionServiceLock.lock();
        try {
            ArrayList<MigrationInfo> arrayList = new ArrayList<MigrationInfo>(this.completedMigrations);
            return arrayList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MigrationInfo> getCompletedMigrations(int partitionId) {
        this.partitionServiceLock.lock();
        try {
            LinkedList<MigrationInfo> migrations = new LinkedList<MigrationInfo>();
            for (MigrationInfo migration : this.completedMigrations) {
                if (partitionId != migration.getPartitionId()) continue;
                migrations.add(migration);
            }
            LinkedList<MigrationInfo> linkedList = migrations;
            return linkedList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    @Override
    public boolean hasOnGoingMigration() {
        return !this.activeMigrations.isEmpty() || this.getMigrationQueueSize() > 0;
    }

    @Override
    public int getMigrationQueueSize() {
        int migrations = this.migrationCount.get();
        return migrations + this.migrationQueue.migrationTaskCount();
    }

    @Override
    public void reset() {
        try {
            if (this.scheduledControlTaskFuture != null) {
                this.scheduledControlTaskFuture.cancel(true);
            }
        }
        catch (Throwable t) {
            this.logger.fine("Cancelling a scheduled control task threw an exception", t);
        }
        this.migrationQueue.clear();
        this.migrationCount.set(0);
        this.activeMigrations.clear();
        this.completedMigrations.clear();
        this.shutdownRequestedMembers.clear();
        this.demoteRequestedMembers.clear();
        this.migrationTasksAllowed.set(true);
    }

    @Override
    public void start() {
        this.migrationThread.start();
    }

    @Override
    public void stop() {
        this.migrationThread.stopNow();
    }

    @Override
    public void scheduleMigration(MigrationInfo migrationInfo) {
        this.migrationQueue.add(() -> new AsyncMigrationTask(migrationInfo).run().toCompletableFuture().join());
    }

    static void applyMigration(InternalPartitionImpl partition, MigrationInfo migrationInfo) {
        PartitionReplica[] members = partition.getReplicasCopy();
        if (migrationInfo.getSourceCurrentReplicaIndex() > -1) {
            members[migrationInfo.getSourceCurrentReplicaIndex()] = null;
        }
        if (migrationInfo.getDestinationCurrentReplicaIndex() > -1) {
            members[migrationInfo.getDestinationCurrentReplicaIndex()] = null;
        }
        members[migrationInfo.getDestinationNewReplicaIndex()] = migrationInfo.getDestination();
        if (migrationInfo.getSourceNewReplicaIndex() > -1) {
            members[migrationInfo.getSourceNewReplicaIndex()] = migrationInfo.getSource();
        }
        partition.setReplicas(members);
    }

    @Override
    public Set<Member> getDataDisownRequestedMembers() {
        HashSet<Member> result = new HashSet<Member>(this.shutdownRequestedMembers);
        result.addAll(this.demoteRequestedMembers);
        return result;
    }

    private void sendDemoteResponseOperation(Member member) {
        if (this.node.getThisAddress().equals(member.getAddress())) {
            this.partitionService.onDemoteResponse();
        } else {
            this.nodeEngine.getOperationService().send(new DemoteResponseOperation(member.getUuid()), member.getAddress());
        }
    }

    private void sendShutdownResponseOperation(Member member) {
        if (this.node.getThisAddress().equals(member.getAddress())) {
            assert (!this.node.isRunning()) : "Node state: " + this.node.getState();
            this.partitionService.onShutdownResponse();
        } else {
            this.nodeEngine.getOperationService().send(new ShutdownResponseOperation(member.getUuid()), member.getAddress());
        }
    }

    @Override
    public boolean shouldTriggerRepartitioningWhenClusterStateAllowsMigration() {
        return this.triggerRepartitioningWhenClusterStateAllowsMigration;
    }

    private void publishCompletedMigrations() {
        if (!this.partitionService.isLocalMemberMaster()) {
            return;
        }
        assert (this.partitionStateManager.isInitialized());
        List<MigrationInfo> migrations = this.getCompletedMigrationsCopy();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Publishing completed migrations [" + migrations.size() + "]: " + migrations);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        ClusterServiceImpl clusterService = this.node.clusterService;
        Set<Member> members = clusterService.getMembers();
        AtomicInteger latch = new AtomicInteger(members.size() - 1);
        for (Member member : members) {
            if (member.localMember()) continue;
            PublishCompletedMigrationsOperation operation = new PublishCompletedMigrationsOperation(migrations);
            InvocationFuture f = operationService.invokeOnTarget("hz:core:partitionService", operation, member.getAddress());
            ((CompletableFuture)f).whenCompleteAsync((response, t) -> {
                if (t == null) {
                    if (!Boolean.TRUE.equals(response)) {
                        this.logger.fine(member + " rejected completed migrations with response " + response);
                        this.partitionService.sendPartitionRuntimeState(member.getAddress());
                        return;
                    }
                    if (latch.decrementAndGet() == 0) {
                        this.logger.fine("Evicting " + migrations.size() + " completed migrations.");
                        this.evictCompletedMigrations(migrations);
                    }
                } else {
                    this.logger.fine("Failure while publishing completed migrations to " + member, (Throwable)t);
                    this.partitionService.sendPartitionRuntimeState(member.getAddress());
                }
            }, this.asyncExecutor);
        }
    }

    @Override
    public MigrationStats getStats() {
        return this.stats;
    }

    private class PublishCompletedMigrationsTask
    implements MigrationRunnable {
        private PublishCompletedMigrationsTask() {
        }

        @Override
        public void run() {
            MigrationManagerImpl.this.partitionService.getPartitionEventManager().sendMigrationProcessCompletedEvent(MigrationManagerImpl.this.stats.toMigrationState());
            MigrationManagerImpl.this.publishCompletedMigrations();
        }
    }

    private class ControlTask
    implements MigrationRunnable {
        private ControlTask() {
        }

        @Override
        public void run() {
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                MigrationManagerImpl.this.migrationQueue.clear();
                if (MigrationManagerImpl.this.partitionService.scheduleFetchMostRecentPartitionTableTaskIfRequired()) {
                    if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                        MigrationManagerImpl.this.logger.finest("FetchMostRecentPartitionTableTask scheduled");
                    }
                    MigrationManagerImpl.this.migrationQueue.add(new ControlTask());
                    return;
                }
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    MigrationManagerImpl.this.logger.finest("RepairPartitionTableTask scheduled");
                }
                MigrationManagerImpl.this.migrationQueue.add(new RepairPartitionTableTask());
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }
    }

    private class AsyncMigrationTask {
        private final MigrationInfo migration;

        AsyncMigrationTask(MigrationInfo migration) {
            this.migration = migration;
            migration.setMaster(MigrationManagerImpl.this.node.getThisAddress());
        }

        CompletionStage<Boolean> run() {
            if (!MigrationManagerImpl.this.partitionService.isLocalMemberMaster()) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            if (this.migration.getSource() == null && this.migration.getDestinationCurrentReplicaIndex() > 0 && this.migration.getDestinationNewReplicaIndex() == 0) {
                throw new IllegalStateException("Promotion migrations must be handled by " + RepairPartitionTableTask.class.getSimpleName() + " -> " + this.migration);
            }
            Member partitionOwner = this.checkMigrationParticipantsAndGetPartitionOwner();
            if (partitionOwner == null) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            return this.executeMigrateOperation(partitionOwner);
        }

        private void beforeMigration() {
            this.migration.setInitialPartitionVersion(MigrationManagerImpl.this.partitionStateManager.getPartitionVersion(this.migration.getPartitionId()));
            MigrationManagerImpl.this.migrationInterceptor.onMigrationStart(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
            if (MigrationManagerImpl.this.logger.isFineEnabled()) {
                MigrationManagerImpl.this.logger.fine("Starting Migration: " + this.migration);
            }
        }

        private Member checkMigrationParticipantsAndGetPartitionOwner() {
            Member partitionOwner = this.getPartitionOwner();
            if (partitionOwner == null) {
                MigrationManagerImpl.this.logger.fine("Partition owner is null. Ignoring " + this.migration);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            if (this.migration.getSource() != null) {
                PartitionReplica source = this.migration.getSource();
                if (MigrationManagerImpl.this.node.getClusterService().getMember(source.address(), source.uuid()) == null) {
                    MigrationManagerImpl.this.logger.fine("Source is not a member anymore. Ignoring " + this.migration);
                    this.triggerRepartitioningAfterMigrationFailure();
                    return null;
                }
            }
            PartitionReplica destination = this.migration.getDestination();
            if (MigrationManagerImpl.this.node.getClusterService().getMember(destination.address(), destination.uuid()) == null) {
                MigrationManagerImpl.this.logger.fine("Destination is not a member anymore. Ignoring " + this.migration);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            return partitionOwner;
        }

        private Member getPartitionOwner() {
            InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(this.migration.getPartitionId());
            PartitionReplica owner = partition.getOwnerReplicaOrNull();
            if (owner == null) {
                MigrationManagerImpl.this.logger.warning("Skipping migration, since partition owner doesn't exist! -> " + this.migration + ", " + partition);
                return null;
            }
            return MigrationManagerImpl.this.node.getClusterService().getMember(owner.address(), owner.uuid());
        }

        private CompletionStage<Boolean> executeMigrateOperation(Member fromMember) {
            InternalCompletableFuture future;
            long start = Timer.nanos();
            try {
                this.beforeMigration();
                List<MigrationInfo> completedMigrations = MigrationManagerImpl.this.getCompletedMigrations(this.migration.getPartitionId());
                MigrationRequestOperation op = new MigrationRequestOperation(this.migration, completedMigrations, 0, MigrationManagerImpl.this.fragmentedMigrationEnabled, MigrationManagerImpl.this.isChunkedMigrationEnabled(), MigrationManagerImpl.this.maxTotalChunkedDataInBytes);
                future = MigrationManagerImpl.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, fromMember.getAddress()).setCallTimeout(MigrationManagerImpl.this.partitionMigrationTimeout).invoke();
            }
            catch (Throwable t2) {
                MigrationManagerImpl.this.logger.warning("Error during " + this.migration, t2);
                future = InternalCompletableFuture.completedExceptionally(t2);
            }
            return ((CompletableFuture)((CompletableFuture)future.handleAsync((done, t) -> {
                MigrationManagerImpl.this.stats.recordMigrationOperationTime();
                MigrationManagerImpl.this.logger.fine("Migration operation response received -> " + this.migration + ", success: " + done + ", failure: " + t);
                if (t != null) {
                    Level level;
                    Level level2 = level = MigrationManagerImpl.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                    if (t instanceof ExecutionException && t.getCause() instanceof PartitionStateVersionMismatchException) {
                        level = Level.FINE;
                    }
                    if (MigrationManagerImpl.this.logger.isLoggable(level)) {
                        MigrationManagerImpl.this.logger.log(level, "Failed migration from " + fromMember + " for " + this.migration, (Throwable)t);
                    }
                    return Boolean.FALSE;
                }
                return done;
            }, MigrationManagerImpl.this.asyncExecutor)).thenComposeAsync(result -> {
                Level level;
                if (result.booleanValue()) {
                    if (MigrationManagerImpl.this.logger.isFineEnabled()) {
                        MigrationManagerImpl.this.logger.fine("Finished Migration: " + this.migration);
                    }
                    return this.migrationOperationSucceeded();
                }
                Level level2 = level = MigrationManagerImpl.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                if (MigrationManagerImpl.this.logger.isLoggable(level)) {
                    MigrationManagerImpl.this.logger.log(level, "Migration failed: " + this.migration);
                }
                this.migrationOperationFailed(fromMember);
                return CompletableFuture.completedFuture(false);
            }, MigrationManagerImpl.this.asyncExecutor)).handleAsync((result, t) -> {
                MigrationManagerImpl.this.stats.recordMigrationTaskTime();
                MigrationManagerImpl.this.partitionService.getPartitionEventManager().sendMigrationEvent(MigrationManagerImpl.this.stats.toMigrationState(), this.migration, TimeUnit.NANOSECONDS.toMillis(Timer.nanosElapsed(start)));
                if (t != null) {
                    Level level = MigrationManagerImpl.this.nodeEngine.isRunning() ? Level.WARNING : Level.FINE;
                    MigrationManagerImpl.this.logger.log(level, "Error during " + this.migration, (Throwable)t);
                    return false;
                }
                return result;
            }, MigrationManagerImpl.this.asyncExecutor);
        }

        private void migrationOperationFailed(Member partitionOwner) {
            this.migration.setStatus(MigrationInfo.MigrationStatus.FAILED);
            MigrationManagerImpl.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migration, false);
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                MigrationManagerImpl.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                MigrationManagerImpl.this.scheduleActiveMigrationFinalization(this.migration);
                int delta = this.migration.getPartitionVersionIncrement() + 1;
                MigrationManagerImpl.this.partitionStateManager.incrementPartitionVersion(this.migration.getPartitionId(), delta);
                this.migration.setPartitionVersionIncrement(delta);
                MigrationManagerImpl.this.node.getNodeExtension().onPartitionStateChange();
                MigrationManagerImpl.this.addCompletedMigration(this.migration);
                if (!partitionOwner.localMember()) {
                    MigrationManagerImpl.this.partitionService.sendPartitionRuntimeState(partitionOwner.getAddress());
                }
                if (!this.migration.getDestination().isIdentical(MigrationManagerImpl.this.node.getLocalMember())) {
                    MigrationManagerImpl.this.partitionService.sendPartitionRuntimeState(this.migration.getDestination().address());
                }
                this.triggerRepartitioningAfterMigrationFailure();
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        private void triggerRepartitioningAfterMigrationFailure() {
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                MigrationManagerImpl.this.pauseMigration();
                MigrationManagerImpl.this.triggerControlTask();
                MigrationManagerImpl.this.resumeMigrationEventually();
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        private CompletionStage<Boolean> migrationOperationSucceeded() {
            MigrationManagerImpl.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migration, true);
            CompletionStage<Boolean> f = MigrationManagerImpl.this.commitMigrationToDestinationAsync(this.migration);
            f = f.thenApplyAsync(commitSuccessful -> {
                MigrationManagerImpl.this.stats.recordDestinationCommitTime();
                MigrationManagerImpl.this.partitionServiceLock.lock();
                try {
                    InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(this.migration.getPartitionId());
                    assert (this.migration.getInitialPartitionVersion() == partition.version()) : "Migration initial version: " + this.migration.getInitialPartitionVersion() + ", Partition version: " + partition.version();
                    if (commitSuccessful.booleanValue()) {
                        this.migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                        MigrationManagerImpl.this.migrationInterceptor.onMigrationCommit(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                        MigrationManagerImpl.applyMigration(partition, this.migration);
                    } else {
                        this.migration.setStatus(MigrationInfo.MigrationStatus.FAILED);
                        MigrationManagerImpl.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migration);
                        int delta = this.migration.getPartitionVersionIncrement() + 1;
                        this.migration.setPartitionVersionIncrement(delta);
                        MigrationManagerImpl.this.partitionStateManager.incrementPartitionVersion(partition.getPartitionId(), delta);
                        if (!this.migration.getDestination().isIdentical(MigrationManagerImpl.this.node.getLocalMember())) {
                            MigrationManagerImpl.this.partitionService.sendPartitionRuntimeState(this.migration.getDestination().address());
                        }
                        this.triggerRepartitioningAfterMigrationFailure();
                    }
                    assert (this.migration.getFinalPartitionVersion() == partition.version()) : "Migration final version: " + this.migration.getFinalPartitionVersion() + ", Partition version: " + partition.version();
                    MigrationManagerImpl.this.addCompletedMigration(this.migration);
                    MigrationManagerImpl.this.scheduleActiveMigrationFinalization(this.migration);
                    MigrationManagerImpl.this.node.getNodeExtension().onPartitionStateChange();
                    if (MigrationManagerImpl.this.completedMigrations.size() >= 10) {
                        MigrationManagerImpl.this.publishCompletedMigrations();
                    }
                }
                finally {
                    MigrationManagerImpl.this.partitionServiceLock.unlock();
                }
                return commitSuccessful;
            }, MigrationManagerImpl.this.asyncExecutor);
            return f;
        }
    }

    static class PartitionTableViewDistanceComparator
    implements Comparator<PartitionTableView> {
        final PartitionTableView basePartitionTableView;

        PartitionTableViewDistanceComparator(PartitionTableView basePartitionTableView) {
            this.basePartitionTableView = basePartitionTableView;
        }

        @Override
        public int compare(PartitionTableView o1, PartitionTableView o2) {
            return this.distanceFromBase(o1) - this.distanceFromBase(o2);
        }

        int distanceFromBase(PartitionTableView partitionTableView) {
            return partitionTableView.distanceOf(this.basePartitionTableView);
        }
    }

    private class ProcessShutdownRequestsTask
    implements MigrationRunnable {
        private ProcessShutdownRequestsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManagerImpl.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                int shutdownRequestCount = MigrationManagerImpl.this.shutdownRequestedMembers.size();
                int dataDisownRequestCount = MigrationManagerImpl.this.getDataDisownRequestedMembers().size();
                if (shutdownRequestCount > 0) {
                    if (dataDisownRequestCount == MigrationManagerImpl.this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR)) {
                        for (Member member : MigrationManagerImpl.this.shutdownRequestedMembers) {
                            MigrationManagerImpl.this.sendShutdownResponseOperation(member);
                        }
                    } else {
                        boolean present = false;
                        for (Member member : MigrationManagerImpl.this.shutdownRequestedMembers) {
                            if (MigrationManagerImpl.this.partitionStateManager.isAbsentInPartitionTable(member)) {
                                MigrationManagerImpl.this.sendShutdownResponseOperation(member);
                                continue;
                            }
                            MigrationManagerImpl.this.logger.warning(member + " requested to shutdown but still in partition table");
                            present = true;
                        }
                        if (present) {
                            MigrationManagerImpl.this.triggerControlTask();
                        }
                    }
                }
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }
    }

    private class SendDemoteResponses
    implements MigrationRunnable {
        private final List<Member> members;

        SendDemoteResponses(List<Member> members) {
            this.members = members;
        }

        @Override
        public void run() {
            List<CompletableFuture<Boolean>> futures = MigrationManagerImpl.this.partitionService.checkClusterPartitionRuntimeStates();
            FutureUtil.waitWithDeadline(futures, 2L, TimeUnit.SECONDS, FutureUtil.RETHROW_ALL_EXCEPT_MEMBER_LEFT);
            for (Member member : this.members) {
                MigrationManagerImpl.this.sendDemoteResponseOperation(member);
            }
        }
    }

    private class ProcessDemoteRequestsTask
    implements MigrationRunnable {
        private ProcessDemoteRequestsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManagerImpl.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                int demoteRequestCount = MigrationManagerImpl.this.demoteRequestedMembers.size();
                if (demoteRequestCount > 0) {
                    boolean present = false;
                    ArrayList<Member> demotedMembers = new ArrayList<Member>(demoteRequestCount);
                    for (Member member : MigrationManagerImpl.this.demoteRequestedMembers) {
                        if (MigrationManagerImpl.this.partitionStateManager.isAbsentInPartitionTable(member)) {
                            demotedMembers.add(member);
                            continue;
                        }
                        MigrationManagerImpl.this.logger.warning(member + " requested to demote but still in partition table");
                        present = true;
                    }
                    if (!demotedMembers.isEmpty()) {
                        MigrationManagerImpl.this.migrationQueue.add(new SendDemoteResponses(demotedMembers));
                    }
                    if (present) {
                        MigrationManagerImpl.this.triggerControlTask();
                    }
                }
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }
    }

    private class RepairPartitionTableTask
    implements MigrationRunnable {
        private RepairPartitionTableTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManagerImpl.this.partitionStateManager.isInitialized()) {
                return;
            }
            ClusterState clusterState = MigrationManagerImpl.this.node.getClusterService().getClusterState();
            if (!clusterState.isMigrationAllowed() && !clusterState.isPartitionPromotionAllowed()) {
                MigrationManagerImpl.this.logger.fine("Will not repair partition table at the moment. Cluster state does not allow to modify partition table.");
                return;
            }
            if (MigrationManagerImpl.this.delayNextRepartitioningExecution) {
                MigrationManagerImpl.this.logger.fine("Delaying next repartitioning execution");
                MigrationManagerImpl.this.delayNextRepartitioningExecution = false;
                ExecutionService executionService = MigrationManagerImpl.this.nodeEngine.getExecutionService();
                MigrationManagerImpl.this.scheduledControlTaskFuture = executionService.schedule(() -> MigrationManagerImpl.this.triggerControlTask(), MigrationManagerImpl.this.autoRebalanceDelaySeconds, TimeUnit.SECONDS);
                return;
            }
            Map<PartitionReplica, Collection<MigrationInfo>> promotions = this.removeUnknownMembersAndCollectPromotions();
            boolean success = this.promoteBackupsForMissingOwners(promotions);
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                if (success) {
                    if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                        MigrationManagerImpl.this.logger.finest("RedoPartitioningTask scheduled");
                    }
                    MigrationManagerImpl.this.migrationQueue.add(new RedoPartitioningTask());
                } else {
                    MigrationManagerImpl.this.triggerControlTask();
                }
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<PartitionReplica, Collection<MigrationInfo>> removeUnknownMembersAndCollectPromotions() {
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                MigrationManagerImpl.this.partitionStateManager.removeUnknownAndLiteMembers();
                HashMap<PartitionReplica, Collection<MigrationInfo>> promotions = new HashMap<PartitionReplica, Collection<MigrationInfo>>();
                for (int partitionId = 0; partitionId < MigrationManagerImpl.this.partitionService.getPartitionCount(); ++partitionId) {
                    MigrationInfo migration = this.createPromotionMigrationIfOwnerIsNull(partitionId);
                    if (migration == null) continue;
                    Collection migrations = promotions.computeIfAbsent(migration.getDestination(), k -> new ArrayList());
                    migrations.add(migration);
                }
                HashMap<PartitionReplica, Collection<MigrationInfo>> hashMap = promotions;
                return hashMap;
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        private boolean promoteBackupsForMissingOwners(Map<PartitionReplica, Collection<MigrationInfo>> promotions) {
            boolean allSucceeded = true;
            for (Map.Entry<PartitionReplica, Collection<MigrationInfo>> entry : promotions.entrySet()) {
                PartitionReplica destination = entry.getKey();
                Collection<MigrationInfo> migrations = entry.getValue();
                allSucceeded &= this.commitPromotionMigrations(destination, migrations);
            }
            return allSucceeded;
        }

        private boolean commitPromotionMigrations(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            MigrationManagerImpl.this.migrationInterceptor.onPromotionStart(MigrationInterceptor.MigrationParticipant.MASTER, migrations);
            boolean success = this.commitPromotionsToDestination(destination, migrations);
            boolean local = destination.isIdentical(MigrationManagerImpl.this.node.getLocalMember());
            if (!local) {
                this.processPromotionCommitResult(destination, migrations, success);
            }
            MigrationManagerImpl.this.migrationInterceptor.onPromotionComplete(MigrationInterceptor.MigrationParticipant.MASTER, migrations, success);
            MigrationManagerImpl.this.partitionService.publishPartitionRuntimeState();
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPromotionCommitResult(PartitionReplica destination, Collection<MigrationInfo> migrations, boolean success) {
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                if (!MigrationManagerImpl.this.partitionStateManager.isInitialized()) {
                    return;
                }
                if (success) {
                    for (MigrationInfo migration : migrations) {
                        InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
                        assert (partition.getOwnerReplicaOrNull() == null) : "Owner should be null: " + partition;
                        assert (destination.equals(partition.getReplica(migration.getDestinationCurrentReplicaIndex()))) : "Invalid replica! Destination: " + destination + ", index: " + migration.getDestinationCurrentReplicaIndex() + ", " + partition;
                        partition.swapReplicas(0, migration.getDestinationCurrentReplicaIndex());
                    }
                } else {
                    PartitionStateManager partitionStateManager = MigrationManagerImpl.this.partitionService.getPartitionStateManager();
                    for (MigrationInfo migration : migrations) {
                        int delta = migration.getPartitionVersionIncrement() + 1;
                        partitionStateManager.incrementPartitionVersion(migration.getPartitionId(), delta);
                    }
                }
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        private MigrationInfo createPromotionMigrationIfOwnerIsNull(int partitionId) {
            InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(partitionId);
            if (partition.getOwnerReplicaOrNull() == null) {
                int index;
                PartitionReplica destination = null;
                for (int i2 = index = 1; i2 < 7; ++i2) {
                    destination = partition.getReplica(i2);
                    if (destination == null) continue;
                    index = i2;
                    break;
                }
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    if (destination != null) {
                        MigrationManagerImpl.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. replicaIndex=" + index + " will be shifted up to 0. " + partition);
                    } else {
                        MigrationManagerImpl.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. there is no other replica to shift up. " + partition);
                    }
                }
                if (destination != null) {
                    MigrationInfo migration = new MigrationInfo(partitionId, null, destination, -1, -1, index, 0);
                    migration.setMaster(MigrationManagerImpl.this.node.getThisAddress());
                    migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    migration.setInitialPartitionVersion(partition.version());
                    return migration;
                }
            }
            if (partition.getOwnerReplicaOrNull() == null) {
                MigrationManagerImpl.this.logger.warning("partitionId=" + partitionId + " is completely lost!");
                PartitionEventManager partitionEventManager = MigrationManagerImpl.this.partitionService.getPartitionEventManager();
                partitionEventManager.sendPartitionLostEvent(partitionId, 6);
            }
            return null;
        }

        private boolean commitPromotionsToDestination(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            assert (!migrations.isEmpty()) : "No promotions to commit! destination=" + destination;
            MemberImpl member = MigrationManagerImpl.this.node.getClusterService().getMember(destination.address(), destination.uuid());
            if (member == null) {
                MigrationManagerImpl.this.logger.warning("Cannot commit promotions. Destination " + destination + " is not a member anymore");
                return false;
            }
            try {
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    MigrationManagerImpl.this.logger.finest("Sending promotion commit operation to " + destination + " for " + migrations);
                }
                PartitionRuntimeState partitionState = MigrationManagerImpl.this.partitionService.createPromotionCommitPartitionState(migrations);
                UUID destinationUuid = member.getUuid();
                PromotionCommitOperation op = new PromotionCommitOperation(partitionState, migrations, destinationUuid);
                InvocationFuture future = MigrationManagerImpl.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(MigrationManagerImpl.this.memberHeartbeatTimeoutMillis).invoke();
                boolean result = (Boolean)future.get();
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    MigrationManagerImpl.this.logger.finest("Promotion commit result " + result + " from " + destination + " for migrations " + migrations);
                }
                return result;
            }
            catch (Throwable t) {
                this.logPromotionCommitFailure(destination, migrations, t);
                if (t.getCause() instanceof OperationTimeoutException) {
                    return this.commitPromotionsToDestination(destination, migrations);
                }
                return false;
            }
        }

        private void logPromotionCommitFailure(PartitionReplica destination, Collection<MigrationInfo> migrations, Throwable t) {
            boolean memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
            int migrationsSize = migrations.size();
            if (memberLeft) {
                if (destination.isIdentical(MigrationManagerImpl.this.node.getLocalMember())) {
                    MigrationManagerImpl.this.logger.fine("Promotion commit failed for " + migrationsSize + " migrations since this node is shutting down.");
                    return;
                }
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    MigrationManagerImpl.this.logger.warning("Promotion commit failed for " + migrations + " since destination " + destination + " left the cluster");
                } else {
                    MigrationManagerImpl.this.logger.warning("Promotion commit failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations") + " since destination " + destination + " left the cluster");
                }
                return;
            }
            if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                MigrationManagerImpl.this.logger.severe("Promotion commit to " + destination + " failed for " + migrations, t);
            } else {
                MigrationManagerImpl.this.logger.severe("Promotion commit to " + destination + " failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations"), t);
            }
        }
    }

    class MigrationPlanTask
    implements MigrationRunnable {
        private final List<Queue<MigrationInfo>> partitionMigrationQueues;
        private final BlockingQueue<MigrationInfo> completed;
        private final IntHashSet migratingPartitions;
        private final Map<Address, Integer> endpoint2MigrationCount = new HashMap<Address, Integer>();
        private int ongoingMigrationCount;
        private boolean failed;
        private volatile boolean aborted;

        MigrationPlanTask(List<Queue<MigrationInfo>> partitionMigrationQueues) {
            this.partitionMigrationQueues = partitionMigrationQueues;
            this.completed = new ArrayBlockingQueue<MigrationInfo>(partitionMigrationQueues.size());
            this.migratingPartitions = new IntHashSet(partitionMigrationQueues.stream().mapToInt(Collection::size).sum(), -1);
        }

        @Override
        public void run() {
            MigrationInfo migration;
            MigrationManagerImpl.this.migrationCount.set(this.partitionMigrationQueues.stream().mapToInt(Collection::size).sum());
            while ((migration = this.next()) != null && !(this.failed | this.aborted)) {
                block5: {
                    this.onStart(migration);
                    try {
                        CompletionStage<Boolean> f = new AsyncMigrationTask(migration).run();
                        f.thenRunAsync(() -> {
                            MigrationManagerImpl.this.logger.fine("AsyncMigrationTask completed: " + migration);
                            boolean offered = this.completed.offer(migration);
                            assert (offered) : "Failed to offer completed migration: " + migration;
                        }, ConcurrencyUtil.CALLER_RUNS);
                    }
                    catch (Throwable e) {
                        MigrationManagerImpl.this.logger.warning("AsyncMigrationTask failed: " + migration, e);
                        boolean offered = this.completed.offer(migration);
                        if ($assertionsDisabled || offered) break block5;
                        throw new AssertionError((Object)("Failed to offer completed migration: " + migration));
                    }
                }
                if (this.migrationDelay()) continue;
                break;
            }
            this.waitOngoingMigrations();
            if (this.failed || this.aborted) {
                MigrationManagerImpl.this.logger.info("Rebalance process was " + (this.failed ? "failed" : "aborted") + ". Ignoring remaining migrations. Will recalculate the new migration plan. (" + MigrationManagerImpl.this.stats.formatToString(MigrationManagerImpl.this.logger.isFineEnabled()) + ")");
                MigrationManagerImpl.this.migrationCount.set(0);
                this.partitionMigrationQueues.clear();
            } else {
                MigrationManagerImpl.this.logger.info("All migration tasks have been completed. (" + MigrationManagerImpl.this.stats.formatToString(MigrationManagerImpl.this.logger.isFineEnabled()) + ")");
            }
        }

        private void onStart(MigrationInfo migration) {
            boolean added = this.migratingPartitions.add(migration.getPartitionId());
            assert (added) : "Couldn't add partitionId to migrating partitions set: " + migration;
            BiFunction<Address, Integer, Integer> inc = (address, current) -> current != null ? current + 1 : 1;
            int count = this.endpoint2MigrationCount.compute(migration.getDestinationAddress(), inc);
            assert (count > 0 && count <= MigrationManagerImpl.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            count = this.endpoint2MigrationCount.compute(this.sourceAddress(migration), inc);
            assert (count > 0 && count <= MigrationManagerImpl.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            ++this.ongoingMigrationCount;
            MigrationManagerImpl.this.migrationCount.decrementAndGet();
        }

        private void onComplete(MigrationInfo migration) {
            boolean removed = this.migratingPartitions.remove(migration.getPartitionId());
            assert (removed) : "Couldn't remove partitionId from migrating partitions set: " + migration;
            BiFunction<Address, Integer, Integer> dec = (address, current) -> current != null ? current - 1 : -1;
            long count = this.endpoint2MigrationCount.compute(migration.getDestinationAddress(), dec).intValue();
            assert (count >= 0L && count < (long)MigrationManagerImpl.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            count = this.endpoint2MigrationCount.compute(this.sourceAddress(migration), dec).intValue();
            assert (count >= 0L && count < (long)MigrationManagerImpl.this.maxParallelMigrations) : "Count: " + count + " -> " + migration;
            if (migration.getStatus() != MigrationInfo.MigrationStatus.SUCCESS) {
                this.failed = true;
            }
            --this.ongoingMigrationCount;
        }

        private boolean processCompleted() {
            MigrationInfo migration;
            boolean ok = false;
            while ((migration = (MigrationInfo)this.completed.poll()) != null) {
                this.onComplete(migration);
                ok = true;
            }
            return ok;
        }

        private MigrationInfo next() {
            MigrationInfo m;
            while ((m = this.next0()) == null && !this.partitionMigrationQueues.isEmpty()) {
                if (!this.processCompleted()) {
                    try {
                        MigrationInfo migration = this.completed.take();
                        this.onComplete(migration);
                    }
                    catch (InterruptedException e) {
                        this.onInterrupted(e);
                        break;
                    }
                }
                if (!(this.failed | this.aborted)) continue;
                break;
            }
            return m;
        }

        private MigrationInfo next0() {
            Iterator<Queue<MigrationInfo>> iter = this.partitionMigrationQueues.iterator();
            while (iter.hasNext()) {
                Queue<MigrationInfo> q = iter.next();
                if (q.isEmpty()) {
                    iter.remove();
                    continue;
                }
                if (!this.select(q.peek())) continue;
                return q.poll();
            }
            return null;
        }

        private boolean select(MigrationInfo m) {
            if (m == null) {
                return true;
            }
            if (this.migratingPartitions.contains(m.getPartitionId())) {
                return false;
            }
            if (this.endpoint2MigrationCount.getOrDefault(m.getDestinationAddress(), 0) == MigrationManagerImpl.this.maxParallelMigrations) {
                return false;
            }
            return this.endpoint2MigrationCount.getOrDefault(this.sourceAddress(m), 0) < MigrationManagerImpl.this.maxParallelMigrations;
        }

        private Address sourceAddress(MigrationInfo m) {
            if (m.getSourceCurrentReplicaIndex() == 0) {
                return m.getSourceAddress();
            }
            InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(m.getPartitionId());
            return partition.getOwnerOrNull();
        }

        private boolean migrationDelay() {
            if (MigrationManagerImpl.this.partitionMigrationInterval > 0L) {
                try {
                    Thread.sleep(MigrationManagerImpl.this.partitionMigrationInterval);
                }
                catch (InterruptedException e) {
                    this.onInterrupted(e);
                    return false;
                }
            }
            return true;
        }

        private void waitOngoingMigrations() {
            boolean interrupted = false;
            while (this.ongoingMigrationCount > 0) {
                try {
                    MigrationInfo migration = this.completed.take();
                    this.onComplete(migration);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        private void onInterrupted(InterruptedException e) {
            MigrationManagerImpl.this.logger.info("MigrationProcessTask is interrupted! Ignoring remaining migrations...", e);
            Thread.currentThread().interrupt();
            this.abort();
        }

        void abort() {
            this.aborted = true;
        }
    }

    class RedoPartitioningTask
    implements MigrationRunnable {
        RedoPartitioningTask() {
        }

        @Override
        public void run() {
            if (!MigrationManagerImpl.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManagerImpl.this.partitionServiceLock.lock();
            try {
                boolean bl = MigrationManagerImpl.this.triggerRepartitioningWhenClusterStateAllowsMigration = !MigrationManagerImpl.this.node.getClusterService().getClusterState().isMigrationAllowed();
                if (MigrationManagerImpl.this.triggerRepartitioningWhenClusterStateAllowsMigration) {
                    if (MigrationManagerImpl.this.logger.isFineEnabled()) {
                        MigrationManagerImpl.this.logger.fine("Migrations are not allowed yet, repartitioning will be triggered when cluster state allows migrations.");
                    }
                    this.assignCompletelyLostPartitions();
                    return;
                }
                PartitionReplica[][] newState = this.repartition();
                if (newState == null) {
                    return;
                }
                this.processNewPartitionState(newState);
                MigrationManagerImpl.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                MigrationManagerImpl.this.migrationQueue.add(new ProcessDemoteRequestsTask());
            }
            finally {
                MigrationManagerImpl.this.partitionServiceLock.unlock();
            }
        }

        private PartitionReplica[][] repartition() {
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            PartitionReplica[][] newState = null;
            if (MigrationManagerImpl.this.node.getNodeExtension().getInternalHotRestartService().isEnabled()) {
                newState = this.checkSnapshots();
            }
            if (newState != null) {
                MigrationManagerImpl.this.logger.info("Identified a snapshot of left member for repartition");
            } else {
                newState = MigrationManagerImpl.this.partitionStateManager.repartition(MigrationManagerImpl.this.getDataDisownRequestedMembers(), null);
            }
            if (newState == null) {
                MigrationManagerImpl.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                return null;
            }
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            return newState;
        }

        PartitionReplica[][] checkSnapshots() {
            HashSet<UUID> shutdownRequestedReplicas = new HashSet<UUID>();
            HashSet<UUID> currentReplicas = new HashSet<UUID>();
            HashMap<UUID, Address> currentAddressMapping = new HashMap<UUID, Address>();
            MigrationManagerImpl.this.getDataDisownRequestedMembers().forEach(member -> shutdownRequestedReplicas.add(member.getUuid()));
            Collection<Member> currentMembers = MigrationManagerImpl.this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            currentMembers.forEach(member -> currentReplicas.add(member.getUuid()));
            currentMembers.forEach(member -> currentAddressMapping.put(member.getUuid(), member.getAddress()));
            TreeSet<PartitionTableView> candidates = new TreeSet<PartitionTableView>(new PartitionTableViewDistanceComparator(MigrationManagerImpl.this.partitionStateManager.getPartitionTable()));
            for (PartitionTableView partitionTableView : MigrationManagerImpl.this.partitionStateManager.snapshots()) {
                if (!partitionTableView.composedOf(currentReplicas, shutdownRequestedReplicas)) continue;
                candidates.add(partitionTableView);
            }
            if (candidates.isEmpty()) {
                return null;
            }
            return ((PartitionTableView)candidates.iterator().next()).toArray(currentAddressMapping);
        }

        private void assignCompletelyLostPartitions() {
            if (!MigrationManagerImpl.this.node.getClusterService().getClusterState().isPartitionPromotionAllowed()) {
                return;
            }
            MigrationManagerImpl.this.logger.fine("Cluster state doesn't allow repartitioning. RedoPartitioningTask will only assign lost partitions.");
            InternalPartition[] partitions = MigrationManagerImpl.this.partitionStateManager.getPartitions();
            PartitionIdSet partitionIds = Arrays.stream(partitions).filter(p -> InternalPartition.replicaIndices().allMatch(i2 -> p.getReplica(i2) == null)).map(IPartition::getPartitionId).collect(Collectors.toCollection(() -> new PartitionIdSet(partitions.length)));
            if (!partitionIds.isEmpty()) {
                PartitionReplica[][] state = MigrationManagerImpl.this.partitionStateManager.repartition(MigrationManagerImpl.this.getDataDisownRequestedMembers(), partitionIds);
                if (state != null) {
                    MigrationManagerImpl.this.logger.warning("Assigning new owners for " + partitionIds.size() + " LOST partitions, when migration is not allowed!");
                    int replicaUpdateCount = (int)partitionIds.stream().flatMap(partitionId -> Arrays.stream(state[partitionId]).filter(Objects::nonNull)).count();
                    MigrationStateImpl[] states = new MigrationStateImpl[]{new MigrationStateImpl(Clock.currentTimeMillis(), replicaUpdateCount, 0, 0L)};
                    PartitionEventManager partitionEventManager = MigrationManagerImpl.this.partitionService.getPartitionEventManager();
                    partitionEventManager.sendMigrationProcessStartedEvent(states[0]);
                    partitionIds.intIterator().forEachRemaining(partitionId -> {
                        InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(partitionId);
                        PartitionReplica[] replicas = state[partitionId];
                        partition.setReplicas(replicas);
                        InternalPartition.replicaIndices().filter(i2 -> replicas[i2] != null).forEach(i2 -> {
                            MigrationInfo migration = new MigrationInfo(partitionId, null, replicas[i2], -1, -1, -1, i2).setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                            states[0] = states[0].onComplete(0L);
                            partitionEventManager.sendMigrationEvent(states[0], migration, 0L);
                        });
                    });
                    partitionEventManager.sendMigrationProcessCompletedEvent(states[0]);
                    MigrationManagerImpl.this.node.getNodeExtension().onPartitionStateChange();
                } else {
                    MigrationManagerImpl.this.logger.warning("Unable to assign LOST partitions");
                }
            }
        }

        private void processNewPartitionState(PartitionReplica[][] newState) {
            int migrationCount = 0;
            ArrayList<Queue<MigrationInfo>> partitionMigrationQueues = new ArrayList<Queue<MigrationInfo>>(newState.length);
            Int2ObjectHashMap<PartitionReplica> lostPartitions = new Int2ObjectHashMap<PartitionReplica>();
            for (int partitionId2 = 0; partitionId2 < newState.length; ++partitionId2) {
                InternalPartitionImpl currentPartition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl(partitionId2);
                Object[] currentReplicas = currentPartition.replicas();
                Object[] newReplicas = newState[partitionId2];
                MigrationCollector migrationCollector = new MigrationCollector(currentPartition);
                if (MigrationManagerImpl.this.logger.isFinestEnabled()) {
                    MigrationManagerImpl.this.logger.finest("Planning migrations for partitionId=" + partitionId2 + ". Current replicas: " + Arrays.toString(currentReplicas) + ", New replicas: " + Arrays.toString(newReplicas));
                }
                MigrationManagerImpl.this.migrationPlanner.planMigrations(partitionId2, (PartitionReplica[])currentReplicas, (PartitionReplica[])newReplicas, migrationCollector);
                MigrationManagerImpl.this.migrationPlanner.prioritizeCopiesAndShiftUps(migrationCollector.migrations);
                if (migrationCollector.lostPartitionDestination != null) {
                    lostPartitions.put(partitionId2, migrationCollector.lostPartitionDestination);
                }
                if (migrationCollector.migrations.isEmpty()) continue;
                partitionMigrationQueues.add(migrationCollector.migrations);
                migrationCount += migrationCollector.migrations.size();
            }
            MigrationManagerImpl.this.stats.markNewRepartition(migrationCount);
            if (migrationCount > 0) {
                MigrationManagerImpl.this.partitionService.getPartitionEventManager().sendMigrationProcessStartedEvent(MigrationManagerImpl.this.stats.toMigrationState());
            }
            if (!lostPartitions.isEmpty()) {
                MigrationManagerImpl.this.logger.warning("Assigning new owners for " + lostPartitions.size() + " LOST partitions!");
                lostPartitions.forEach((partitionId, destination) -> {
                    InternalPartitionImpl partition = MigrationManagerImpl.this.partitionStateManager.getPartitionImpl((int)partitionId);
                    this.assignLostPartitionOwner(partition, (PartitionReplica)destination);
                });
                MigrationManagerImpl.this.node.getNodeExtension().onPartitionStateChange();
            }
            MigrationManagerImpl.this.partitionService.publishPartitionRuntimeState();
            if (migrationCount > 0) {
                this.scheduleMigrations(partitionMigrationQueues);
                MigrationManagerImpl.this.schedule(new PublishCompletedMigrationsTask());
            }
            this.logMigrationStatistics(migrationCount);
        }

        private void scheduleMigrations(List<Queue<MigrationInfo>> partitionMigrationQueues) {
            MigrationManagerImpl.this.schedule(new MigrationPlanTask(partitionMigrationQueues));
        }

        private void logMigrationStatistics(int migrationCount) {
            if (migrationCount > 0) {
                MigrationManagerImpl.this.logger.info("Repartitioning cluster data. Migration tasks count: " + migrationCount);
            } else {
                MigrationManagerImpl.this.logger.info("Partition balance is ok, no need to repartition.");
            }
        }

        private void assignLostPartitionOwner(InternalPartitionImpl partition, PartitionReplica newOwner) {
            partition.setReplica(0, newOwner);
            MigrationManagerImpl.this.stats.incrementCompletedMigrations();
            MigrationInfo migrationInfo = new MigrationInfo(partition.getPartitionId(), null, newOwner, -1, -1, -1, 0);
            migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            MigrationManagerImpl.this.partitionService.getPartitionEventManager().sendMigrationEvent(MigrationManagerImpl.this.stats.toMigrationState(), migrationInfo, 0L);
        }

        private boolean migrationsTasksAllowed() {
            boolean hasMigrationTasks;
            boolean migrationTasksAllowed = MigrationManagerImpl.this.areMigrationTasksAllowed();
            boolean bl = hasMigrationTasks = MigrationManagerImpl.this.migrationQueue.migrationTaskCount() > 1;
            if (migrationTasksAllowed && !hasMigrationTasks) {
                return true;
            }
            MigrationManagerImpl.this.triggerControlTask();
            return false;
        }

        private class MigrationCollector
        implements MigrationPlanner.MigrationDecisionCallback {
            private final InternalPartitionImpl partition;
            private final LinkedList<MigrationInfo> migrations = new LinkedList();
            private PartitionReplica lostPartitionDestination;

            MigrationCollector(InternalPartitionImpl partition) {
                this.partition = partition;
            }

            @Override
            public void migrate(PartitionReplica source, int sourceCurrentReplicaIndex, int sourceNewReplicaIndex, PartitionReplica destination, int destinationCurrentReplicaIndex, int destinationNewReplicaIndex) {
                int partitionId = this.partition.getPartitionId();
                if (MigrationManagerImpl.this.logger.isFineEnabled()) {
                    MigrationManagerImpl.this.logger.fine("Planned migration -> partitionId=" + partitionId + ", source=" + source + ", sourceCurrentReplicaIndex=" + sourceCurrentReplicaIndex + ", sourceNewReplicaIndex=" + sourceNewReplicaIndex + ", destination=" + destination + ", destinationCurrentReplicaIndex=" + destinationCurrentReplicaIndex + ", destinationNewReplicaIndex=" + destinationNewReplicaIndex);
                }
                if (source == null && destinationCurrentReplicaIndex == -1 && destinationNewReplicaIndex == 0) {
                    assert (destination != null) : "partitionId=" + partitionId + " destination is null";
                    assert (sourceCurrentReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceNewReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceNewReplicaIndex;
                    assert (this.lostPartitionDestination == null) : "Current: " + this.lostPartitionDestination + ", New: " + destination;
                    this.lostPartitionDestination = destination;
                } else if (destination == null && sourceNewReplicaIndex == -1) {
                    assert (source != null) : "partitionId=" + partitionId + " source is null";
                    assert (sourceCurrentReplicaIndex != -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceCurrentReplicaIndex != 0) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    PartitionReplica currentSource = this.partition.getReplica(sourceCurrentReplicaIndex);
                    assert (source.equals(currentSource)) : "partitionId=" + partitionId + " current source=" + source + " is different than expected source=" + source;
                    this.partition.setReplica(sourceCurrentReplicaIndex, null);
                } else {
                    MigrationInfo migration = new MigrationInfo(partitionId, source, destination, sourceCurrentReplicaIndex, sourceNewReplicaIndex, destinationCurrentReplicaIndex, destinationNewReplicaIndex);
                    this.migrations.add(migration);
                }
            }
        }
    }
}

