/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAccumulator;

public class MigrationTimer {
    private final LongAccumulator elapsedNanoseconds = new LongAccumulator(Long::max, 0L);
    private volatile long lastTotalElapsedNanoseconds;

    protected void markNewRepartition() {
        this.lastTotalElapsedNanoseconds = this.getTotalElapsedNanoseconds();
        this.elapsedNanoseconds.reset();
    }

    protected void calculateElapsed(long lastRepartitionNanos) {
        this.elapsedNanoseconds.accumulate(Timer.nanosElapsed(lastRepartitionNanos));
    }

    public long getElapsedNanoseconds() {
        return this.elapsedNanoseconds.get();
    }

    public long getElapsedMilliseconds() {
        return TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanoseconds());
    }

    public long getTotalElapsedNanoseconds() {
        return this.lastTotalElapsedNanoseconds + this.getElapsedNanoseconds();
    }

    public long getTotalElapsedMilliseconds() {
        return TimeUnit.NANOSECONDS.toMillis(this.getTotalElapsedNanoseconds());
    }
}

