/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractGenericRecordBuilder
implements GenericRecordBuilder {
    AbstractGenericRecordBuilder() {
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt32(@Nonnull String fieldName, int value) {
        return this.write(fieldName, value, FieldKind.INT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt64(@Nonnull String fieldName, long value) {
        return this.write(fieldName, value, FieldKind.INT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, @Nullable String value) {
        return this.write(fieldName, value, FieldKind.STRING);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        return this.write(fieldName, value, FieldKind.BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt8(@Nonnull String fieldName, byte value) {
        return this.write(fieldName, value, FieldKind.INT8);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        throw new UnsupportedOperationException("Compact format does not support writing a char field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat64(@Nonnull String fieldName, double value) {
        return this.write(fieldName, value, FieldKind.FLOAT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat32(@Nonnull String fieldName, float value) {
        return this.write(fieldName, Float.valueOf(value), FieldKind.FLOAT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt16(@Nonnull String fieldName, short value) {
        return this.write(fieldName, value, FieldKind.INT16);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        AbstractGenericRecordBuilder.checkCompactGenericRecord(value);
        return this.write(fieldName, value, FieldKind.COMPACT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        return this.write(fieldName, value, FieldKind.DECIMAL);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        return this.write(fieldName, value, FieldKind.TIME);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        return this.write(fieldName, value, FieldKind.DATE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        return this.write(fieldName, value, FieldKind.TIMESTAMP);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        return this.write(fieldName, value, FieldKind.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        if (value != null) {
            for (GenericRecord genericRecord : value) {
                AbstractGenericRecordBuilder.checkCompactGenericRecord(genericRecord);
            }
        }
        return this.write(fieldName, value, FieldKind.ARRAY_OF_COMPACT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_INT8);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfChar(@Nonnull String fieldName, @Nullable char[] value) {
        throw new UnsupportedOperationException("Compact format does not support writing an array of chars field");
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt32(@Nonnull String fieldName, @Nullable int[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_INT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt64(@Nonnull String fieldName, @Nullable long[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_INT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_FLOAT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_FLOAT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfInt16(@Nonnull String fieldName, @Nullable short[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_INT16);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfString(@Nonnull String fieldName, @Nullable String[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_STRING);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_DECIMAL);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_TIME);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_DATE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_TIMESTAMP);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_INT8);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_FLOAT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_FLOAT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_INT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_INT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        return this.write(fieldName, value, FieldKind.NULLABLE_INT16);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_INT8);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_FLOAT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_INT32);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_FLOAT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_INT64);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        return this.write(fieldName, value, FieldKind.ARRAY_OF_NULLABLE_INT16);
    }

    protected abstract GenericRecordBuilder write(@Nonnull String var1, Object var2, FieldKind var3);

    public static void checkTypeWithSchema(Schema schema, @Nonnull String fieldName, FieldKind fieldKind) {
        FieldDescriptor fd = schema.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for " + schema);
        }
        if (fd.getKind() != fieldKind) {
            throw new HazelcastSerializationException("Invalid field kind: '" + fieldName + "' for " + schema + ", expected : " + fd.getKind() + ", given : " + fieldKind);
        }
    }

    private static void checkCompactGenericRecord(GenericRecord value) {
        if (value != null && !(value instanceof CompactGenericRecord)) {
            throw new HazelcastSerializationException("You can only use Compact GenericRecords in a Compact GenericRecordBuilder");
        }
    }
}

