/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import java.io.IOException;

public interface OffsetReader {
    public static final int NULL_OFFSET = -1;
    public static final int BYTE_OFFSET_READER_RANGE = 255;
    public static final int SHORT_OFFSET_READER_RANGE = 65535;
    public static final OffsetReader BYTE_OFFSET_READER = (in, varSizedOffsetsOffset, index) -> {
        byte offset = in.readByte(varSizedOffsetsOffset + index);
        if (offset == -1) {
            return offset;
        }
        return Byte.toUnsignedInt(offset);
    };
    public static final OffsetReader SHORT_OFFSET_READER = (in, varSizedOffsetsOffset, index) -> {
        short offset = in.readShort(varSizedOffsetsOffset + index * 2);
        if (offset == -1) {
            return offset;
        }
        return Short.toUnsignedInt(offset);
    };
    public static final OffsetReader INT_OFFSET_READER = (in, varSizedOffsetsOffset, index) -> in.readInt(varSizedOffsetsOffset + index * 4);

    public static OffsetReader readerFor(int dataLength) {
        if (dataLength < 255) {
            return BYTE_OFFSET_READER;
        }
        if (dataLength < 65535) {
            return SHORT_OFFSET_READER;
        }
        return INT_OFFSET_READER;
    }

    public int read(BufferObjectDataInput var1, int var2, int var3) throws IOException;
}

