/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.impl.execution.BroadcastItem;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.util.CircularListCursor;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.Nullable;

@FunctionalInterface
public interface OutboundCollector {
    public ProgressState offer(Object var1);

    default public ProgressState offerBroadcast(BroadcastItem item) {
        return this.offer(item);
    }

    default public ProgressState offer(Object item, int partitionId) {
        return this.offer(item);
    }

    @Nullable
    default public int[] getPartitions() {
        throw new UnsupportedOperationException();
    }

    public static OutboundCollector compositeCollector(OutboundCollector[] collectors, EdgeDef outboundEdge, int partitionCount, boolean local, boolean forceWrapping) {
        if (!forceWrapping && collectors.length == 1) {
            return collectors[0];
        }
        switch (outboundEdge.routingPolicy()) {
            case UNICAST: 
            case ISOLATED: {
                return new RoundRobin(collectors);
            }
            case PARTITIONED: {
                return new Partitioned(collectors, outboundEdge.partitioner(), partitionCount);
            }
            case BROADCAST: {
                return new Broadcast(collectors);
            }
            case FANOUT: {
                return local ? new RoundRobin(collectors) : new Broadcast(collectors);
            }
        }
        throw new AssertionError((Object)("Missing case label for " + outboundEdge.routingPolicy()));
    }

    public static class RoundRobin
    extends Composite {
        private final CircularListCursor<OutboundCollector> cursor;

        RoundRobin(OutboundCollector[] collectors) {
            super(collectors);
            this.cursor = new CircularListCursor<OutboundCollector>(collectors);
        }

        @Override
        public ProgressState offer(Object item) {
            ProgressState result;
            OutboundCollector first = this.cursor.value();
            do {
                if ((result = this.cursor.value().offer(item)).isDone()) {
                    this.cursor.advance();
                    return result;
                }
                if (result.isMadeProgress()) {
                    return result;
                }
                this.cursor.advance();
            } while (this.cursor.value() != first);
            return result;
        }
    }

    public static class Partitioned
    extends Composite {
        private final Partitioner partitioner;
        private final OutboundCollector[] partitionLookupTable;
        private final int[] partitions;
        private int partitionId = -1;

        Partitioned(OutboundCollector[] collectors, Partitioner partitioner, int partitionCount) {
            super(collectors);
            this.partitioner = partitioner;
            this.partitionLookupTable = new OutboundCollector[partitionCount];
            this.partitions = new int[Arrays.stream(collectors).mapToInt(c -> c.getPartitions().length).sum()];
            int idx = 0;
            for (OutboundCollector collector : collectors) {
                int[] partitionsForCollector = collector.getPartitions();
                assert (partitionsForCollector != null) : "collector must define partitions";
                for (int partition : partitionsForCollector) {
                    assert (this.partitionLookupTable[partition] == null) : "duplicate partition " + partition;
                    this.partitionLookupTable[partition] = collector;
                }
                System.arraycopy(partitionsForCollector, 0, this.partitions, idx, partitionsForCollector.length);
                idx += partitionsForCollector.length;
            }
        }

        @Override
        public ProgressState offer(Object item) {
            ProgressState result;
            if (this.partitionId == -1) {
                this.partitionId = this.partitioner.getPartition(item, this.partitionLookupTable.length);
                assert (this.partitionId >= 0 && this.partitionId < this.partitionLookupTable.length) : "Partition number out of range: " + this.partitionId + ", offending item: " + item;
            }
            if ((result = this.offer(item, this.partitionId)).isDone()) {
                this.partitionId = -1;
            }
            return result;
        }

        @Override
        public ProgressState offer(Object item, int partitionId) {
            OutboundCollector collector = this.partitionLookupTable[partitionId];
            assert (collector != null) : "This item should not be handled by this collector as the requested partitionId is not present";
            return collector.offer(item, partitionId);
        }

        @Override
        public int[] getPartitions() {
            return this.partitions;
        }
    }

    public static class Broadcast
    extends Composite {
        Broadcast(OutboundCollector[] collectors) {
            super(collectors);
        }

        @Override
        public ProgressState offer(Object item) {
            this.progTracker.reset();
            for (int i2 = 0; i2 < this.collectors.length; ++i2) {
                if (this.broadcastTracker.get(i2)) continue;
                ProgressState result = this.collectors[i2].offer(item);
                this.progTracker.mergeWith(result);
                if (!result.isDone()) continue;
                this.broadcastTracker.set(i2);
            }
            if (this.progTracker.isDone()) {
                this.broadcastTracker.clear();
            }
            return this.progTracker.toProgressState();
        }
    }

    public static abstract class Composite
    implements OutboundCollector {
        protected final OutboundCollector[] collectors;
        protected final ProgressTracker progTracker = new ProgressTracker();
        protected final BitSet broadcastTracker;

        Composite(OutboundCollector[] collectors) {
            this.collectors = collectors;
            this.broadcastTracker = new BitSet(collectors.length);
        }

        @Override
        public ProgressState offerBroadcast(BroadcastItem item) {
            this.progTracker.reset();
            for (int i2 = 0; i2 < this.collectors.length; ++i2) {
                if (this.broadcastTracker.get(i2)) continue;
                ProgressState result = this.collectors[i2].offerBroadcast(item);
                this.progTracker.mergeWith(result);
                if (!result.isDone()) continue;
                this.broadcastTracker.set(i2);
            }
            if (this.progTracker.isDone()) {
                this.broadcastTracker.clear();
            }
            return this.progTracker.toProgressState();
        }
    }
}

