/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.NodeWideUsedCapacityCounter;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class TxnReservedCapacityCounterImpl
implements TxnReservedCapacityCounter {
    private final ConcurrentMap<UUID, Long> reservedCapacityCountByTxId;
    private final NodeWideUsedCapacityCounter nodeWideUsedCapacityCounter;

    public TxnReservedCapacityCounterImpl(NodeWideUsedCapacityCounter nodeWideUsedCapacityCounter) {
        this.nodeWideUsedCapacityCounter = nodeWideUsedCapacityCounter;
        this.reservedCapacityCountByTxId = new ConcurrentHashMap<UUID, Long>();
    }

    @Override
    public void increment(@Nonnull UUID txnId, boolean backup) {
        if (txnId.equals(NULL_UUID)) {
            return;
        }
        this.reservedCapacityCountByTxId.compute(txnId, (ignored, currentCapacityCount) -> {
            if (backup) {
                this.nodeWideUsedCapacityCounter.add(1L);
            } else {
                this.nodeWideUsedCapacityCounter.checkAndAddCapacityOrThrowException(1);
            }
            return currentCapacityCount == null ? 1L : currentCapacityCount + 1L;
        });
    }

    @Override
    public void putAll(@Nonnull Map<UUID, Long> reservedCapacityPerTxnId) {
        for (Long count : reservedCapacityPerTxnId.values()) {
            this.nodeWideUsedCapacityCounter.add(count);
        }
        this.reservedCapacityCountByTxId.putAll(reservedCapacityPerTxnId);
    }

    @Override
    public boolean hasReservedCapacity(@Nonnull UUID txnId) {
        if (txnId.equals(NULL_UUID)) {
            return false;
        }
        return this.reservedCapacityCountByTxId.containsKey(txnId);
    }

    @Override
    public void decrement(@Nonnull UUID txnId) {
        this.decrement0(txnId, true);
    }

    private void decrement0(UUID txnId, boolean decrementNodeWideCounter) {
        if (txnId.equals(NULL_UUID)) {
            return;
        }
        this.reservedCapacityCountByTxId.computeIfPresent(txnId, (ignored, currentCapacityCount) -> {
            if (decrementNodeWideCounter) {
                this.nodeWideUsedCapacityCounter.add(-1L);
            }
            return currentCapacityCount == 1L ? null : Long.valueOf(currentCapacityCount - 1L);
        });
    }

    @Override
    public void decrementOnlyReserved(@Nonnull UUID txnId) {
        this.decrement0(txnId, false);
    }

    @Override
    public void releaseAllReservations() {
        for (Long counter : this.reservedCapacityCountByTxId.values()) {
            this.nodeWideUsedCapacityCounter.add(-counter.longValue());
        }
        this.reservedCapacityCountByTxId.clear();
    }

    @Override
    public Map<UUID, Long> getReservedCapacityCountPerTxnId() {
        return this.reservedCapacityCountByTxId;
    }
}

