/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.ObjectRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.SimpleRecord;
import com.hazelcast.map.impl.record.SimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.SimpleRecordWithLRUEviction;
import javax.annotation.Nonnull;

public class ObjectRecordFactory
implements RecordFactory<Object> {
    private final MapContainer mapContainer;
    private final SerializationService serializationService;

    public ObjectRecordFactory(MapContainer mapContainer, SerializationService serializationService) {
        this.serializationService = serializationService;
        this.mapContainer = mapContainer;
    }

    @Override
    public Record<Object> newRecord(Data key, Object value) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean perEntryStatsEnabled = mapConfig.isPerEntryStatsEnabled();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        Object objectValue = this.serializationService.toObject(value);
        return this.newRecord(mapConfig, perEntryStatsEnabled, hasEviction, objectValue);
    }

    @Nonnull
    private Record<Object> newRecord(MapConfig mapConfig, boolean perEntryStatsEnabled, boolean hasEviction, Object objectValue) {
        if (perEntryStatsEnabled) {
            return new ObjectRecordWithStats(objectValue);
        }
        if (hasEviction) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return new SimpleRecordWithLRUEviction<Object>(objectValue);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return new SimpleRecordWithLFUEviction<Object>(objectValue);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return new SimpleRecord<Object>(objectValue);
            }
            return new ObjectRecordWithStats(objectValue);
        }
        return new SimpleRecord<Object>(objectValue);
    }
}

