/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.discovery.multicast.impl;

import com.hazelcast.spi.discovery.multicast.impl.MulticastMemberInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MulticastDiscoverySerializationHelper {
    private final boolean safeSerialization;

    public MulticastDiscoverySerializationHelper(boolean safeSerialization) {
        this.safeSerialization = safeSerialization;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] serialize(MulticastMemberInfo memberInfo) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.safeSerialization) {
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeBoolean(memberInfo != null);
                if (memberInfo == null) return bos.toByteArray();
                dos.writeUTF(memberInfo.getHost());
                dos.writeInt(memberInfo.getPort());
                return bos.toByteArray();
            }
        }
        try (ObjectOutputStream oo = new ObjectOutputStream(bos);){
            oo.writeObject(memberInfo);
            return bos.toByteArray();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MulticastMemberInfo deserialize(byte[] data) throws IOException, ClassNotFoundException {
        if (data == null) {
            return null;
        }
        MulticastMemberInfo memberInfo = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        if (this.safeSerialization) {
            try (DataInputStream dis = new DataInputStream(bis);){
                boolean memberInfoIncluded = dis.readBoolean();
                if (!memberInfoIncluded) return memberInfo;
                String tmpHost = dis.readUTF();
                int tmpPort = dis.readInt();
                memberInfo = new MulticastMemberInfo(tmpHost, tmpPort);
                return memberInfo;
            }
        }
        try (ObjectInputStream in = new ObjectInputStream(bis);){
            memberInfo = (MulticastMemberInfo)in.readObject();
            return memberInfo;
        }
    }
}

