/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;

public class ThreadDumper {
    private static final String CRLF = System.lineSeparator();
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    private static final ScheduledExecutorService scheduler;
    private static volatile ThreadGroup rootTG;

    public ThreadDumper(long interval) {
        LOGGER.log(Level.INFO, "added thread dumper scheduler");
        ThreadDumperRunner r = new ThreadDumperRunner();
        scheduler.scheduleAtFixedRate(r, interval, interval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThreadDump(boolean dumpDaemon) {
        ThreadInfo[] threadInfos;
        StringBuilder tdump = new StringBuilder();
        tdump.append("======================================================================").append(CRLF);
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            tdump.append("==== Thread Dump ").append(df.format(new Date())).append("                               =====").append(CRLF);
        }
        tdump.append("======================================================================").append(CRLF);
        ThreadMXBean tbean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = tbean.getThreadInfo(tbean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            Thread.State state = threadInfo.getThreadState();
            Thread t = ThreadDumper.getThread(threadInfo.getThreadId());
            if (!dumpDaemon && t.isDaemon()) continue;
            tdump.append('\"').append(threadInfo.getThreadName()).append('\"').append(CRLF);
            tdump.append("   java.lang.Thread.State: ").append((Object)state).append(t.isDaemon() ? " [DAEMON]" : " [normal]").append(CRLF);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                tdump.append("        at ").append(stackTraceElement).append(CRLF);
            }
            tdump.append("======================================================================").append(CRLF);
        }
        return tdump.toString();
    }

    private static Thread getThread(long id) {
        Thread[] threads;
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        ThreadGroup root = rootTG;
        if (root == null) {
            root = Thread.currentThread().getThreadGroup();
            while (root.getParent() != null) {
                root = root.getParent();
            }
            rootTG = root;
        }
        int nalloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nalloc *= 2], true)) == nalloc) {
        }
        for (Thread thread : Arrays.copyOf(threads, n)) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        scheduler = Executors.newScheduledThreadPool(1, new ThreadDumperThreadFactory());
        rootTG = null;
    }

    private static class ThreadDumperRunner
    implements Runnable {
        private ThreadDumperRunner() {
        }

        @Override
        public void run() {
            try {
                LOGGER.log(Level.INFO, "dumping threads");
                for (String s : ThreadDumper.getThreadDump(false).split(CRLF)) {
                    LOGGER.log(Level.INFO, s);
                }
                LOGGER.log(Level.INFO, "threads dumped");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while executing thread dump", e);
            }
        }
    }

    private static class ThreadDumperThreadFactory
    implements ThreadFactory {
        private ThreadDumperThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "ThreadDumper");
            t.setDaemon(true);
            return t;
        }
    }
}

