/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.HeaderRequest;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class HeaderRequestCapability
extends HeaderRequest
implements Serializable {
    public static final long serialVersionUID = 100000000028L;
    protected UsagePeriod period = null;

    public HeaderRequestCapability() {
    }

    public HeaderRequestCapability(ASN1Encodable ae) throws IOException {
        this();
        if (ae != null) {
            this.parse(ae);
        }
    }

    @Override
    protected final void parse(ASN1Encodable ae) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance(ae);
        this.period = new UsagePeriod(s1.getObjectAt(0));
    }

    @Override
    protected HeaderRequest getRequest(ASN1Encodable ae) throws IOException {
        return new HeaderRequestCapability(ae);
    }

    public int getId() {
        return 1;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        if (this.period != null) {
            sb.append(prefix).append("  period ").append(this.period.dumpValueNotation(prefix + "  ", dumpType)).append("\r\n");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    ASN1Object intToAsn1Object(DumpType dt) {
        ASN1EncodableVector s1 = new ASN1EncodableVector();
        s1.add(this.period.toAsn1Object(dt));
        return new DERSequence(s1);
    }
}

