/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;

public class MacAlgorithm
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000010L;
    Algorithm alg = null;

    public MacAlgorithm() {
        this.alg = Algorithm.getDefault(AlgorithmType.HASHING);
    }

    public MacAlgorithm(ASN1Encodable to) throws IOException {
        if (to == null) {
            throw new NullPointerException("object may not be null");
        }
        this.parse(to);
    }

    public MacAlgorithm(Algorithm a) throws IOException {
        if (a == null) {
            throw new NullPointerException("object may not be null");
        }
        if (a.getAlgorithmType() != AlgorithmType.HASHING) {
            throw new IOException("Algorithm must be of type hashing");
        }
        this.alg = a;
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        Algorithm a = Algorithm.getById(ASN1Integer.getInstance(to).getValue().intValue());
        if (a == null || a.getAlgorithmType() != AlgorithmType.HASHING) {
            throw new IOException("Only hashing algorithms may be parsed");
        }
        this.alg = a;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) {
        return new ASN1Integer(this.alg.getId());
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        return "" + this.alg.getId();
    }

    public Algorithm setAlgorithm(Algorithm alg) throws IOException {
        if (alg.getAlgorithmType() != AlgorithmType.HASHING) {
            throw new IOException("Algorithm must be of type hashing");
        }
        Algorithm old = this.alg;
        this.alg = alg;
        return old;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }
}

