/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.BlendingSpec;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.OperationFactory;
import net.messagevortex.asn1.PrefixBlock;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class RoutingCombo
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000014L;
    public static final int MURB = 131;
    public static final int OPERATIONS = 132;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static AsymmetricKey dummyKey;
    public static final int PREFIX_PLAIN = 331;
    public static final int PREFIX_ENCRYPTED = 332;
    public static final int ROUTING_PLAIN = 333;
    public static final int ROUTING_ENCRYPTED = 334;
    private byte[] encrypted = null;
    private BlendingSpec recipient;
    private long minProcessTime = 0L;
    private long maxProcessTime = 0L;
    private PrefixBlock[] prefix;
    private RoutingCombo[] nextHop;
    private long forwardSecret = -1L;
    private RoutingCombo murbReplyBlock = null;
    private long murbMaxReplay = -1L;
    private UsagePeriod murbValidity = null;
    private final List<Operation> operation = new ArrayList<Operation>();

    public RoutingCombo() {
        this.recipient = new BlendingSpec("");
        this.prefix = new PrefixBlock[0];
        this.nextHop = new RoutingCombo[0];
    }

    public RoutingCombo(byte[] b, boolean encrypted) throws IOException {
        if (encrypted) {
            this.encrypted = Arrays.copyOf(b, b.length);
        } else {
            this.parse(b);
        }
    }

    public RoutingCombo(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    private PrefixBlock[] getPrefix(ASN1Primitive seq) throws IOException {
        ASN1Sequence seq1 = ASN1Sequence.getInstance(seq);
        ArrayList<PrefixBlock> ap = new ArrayList<PrefixBlock>(seq1.size());
        for (ASN1Encodable e : seq1) {
            ap.add(new PrefixBlock(e.toASN1Primitive(), null));
        }
        return ap.toArray(new PrefixBlock[ap.size()]);
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1Sequence s2;
        if (this.isEncrypted()) {
            throw new IOException("Unable to encode to asn encrypted stream");
        }
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.recipient = new BlendingSpec(s1.getObjectAt(i2++));
        this.minProcessTime = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        this.maxProcessTime = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        ASN1TaggedObject ae = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        switch (ae.getTagNo()) {
            case 331: {
                LOGGER.log(Level.INFO, "parsing plain prefix");
                this.prefix = this.getPrefix(ae.getBaseObject().toASN1Primitive());
                break;
            }
            case 332: {
                LOGGER.log(Level.INFO, "parsing encrypted prefix");
                this.prefix = this.getPrefix(ae.getBaseObject().toASN1Primitive());
                break;
            }
            default: {
                throw new IOException("Error parsing prefix (expected: 331 or 332;got:" + ae.getTagNo() + ")");
            }
        }
        if (this.prefix == null) {
            throw new NullPointerException("prefix should not parse to null (decoding)");
        }
        ae = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        switch (ae.getTagNo()) {
            case 333: 
            case 334: {
                ASN1Sequence seq = ASN1Sequence.getInstance(ae.getBaseObject());
                ArrayList<RoutingCombo> p2 = new ArrayList<RoutingCombo>(seq.size());
                for (ASN1Encodable b : seq) {
                    p2.add(new RoutingCombo(b));
                }
                if (p2.size() != this.prefix.length) {
                    throw new IOException("missmatch in length of prefix and router block");
                }
                this.nextHop = p2.toArray(new RoutingCombo[p2.size()]);
                break;
            }
            default: {
                throw new IOException("Error parsing prefix (expected: 333 or 334;got:" + ae.getTagNo() + ")");
            }
        }
        this.forwardSecret = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().longValue();
        ae = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        if (ae.getTagNo() == 131) {
            s2 = ASN1Sequence.getInstance(ae.getBaseObject());
            if (s2.size() != 3) {
                throw new IOException("invalid sequence size for reply block (got: " + s2.size() + "; expected: 3)");
            }
            this.murbReplyBlock = new RoutingCombo(s2.getObjectAt(0));
            this.murbMaxReplay = ASN1Integer.getInstance(s2.getObjectAt(1)).getPositiveValue().intValue();
            this.murbValidity = new UsagePeriod(s2.getObjectAt(2));
        } else if (ae.getTagNo() != 132) {
            throw new IOException("Got unknown tag number (got: " + ae.getTagNo() + "; expected: 131 or 132)");
        }
        int n = --i2;
        ++i2;
        ae = ASN1TaggedObject.getInstance(s1.getObjectAt(n));
        if (ae.getTagNo() == 132) {
            s2 = ASN1Sequence.getInstance(ae.getBaseObject());
            ArrayList<Operation> o = new ArrayList<Operation>();
            if (s2.size() > 0) {
                for (ASN1Encodable obj : s2) {
                    Operation op = OperationFactory.getInstance(obj);
                    o.add(op);
                }
                this.operation.clear();
                this.operation.addAll(o);
            }
        } else {
            throw new IOException("Got unknown tag number (got: " + ae.getTagNo() + "; expected: 132)");
        }
    }

    public boolean isEncrypted() {
        return this.encrypted != null;
    }

    public long getFirstProcessTime() {
        return this.minProcessTime;
    }

    public long setFistProcessTime(long minProcessTime) {
        long old = minProcessTime;
        this.encrypted = null;
        this.minProcessTime = minProcessTime;
        return old;
    }

    public long getLastProcessTime() {
        return this.maxProcessTime;
    }

    public long setLastProcessTime(long maxProcessTime) {
        long old = this.maxProcessTime;
        this.encrypted = null;
        this.maxProcessTime = maxProcessTime;
        return old;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        RoutingCombo[] v3;
        ASN1EncodableVector v2;
        if (this.prefix == null) {
            throw new NullPointerException("prefix may not be null when encoding");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.recipient.toAsn1Object(dumpType));
        v.add(new ASN1Integer(this.minProcessTime));
        v.add(new ASN1Integer(this.maxProcessTime));
        switch (dumpType) {
            case ALL_UNENCRYPTED: 
            case INTERNAL: {
                v2 = new ASN1EncodableVector();
                for (PrefixBlock p : this.prefix) {
                    v2.add(p.toAsn1Object(dumpType));
                }
                v.add(new DERTaggedObject(331, new DERSequence(v2)));
                break;
            }
            case PRIVATE_COMMENTED: 
            case PUBLIC_ONLY: 
            case ALL: {
                v3 = new ASN1EncodableVector();
                PrefixBlock[] prefixBlockArray = this.prefix;
                int n = prefixBlockArray.length;
                for (int p = 0; p < n; ++p) {
                    PrefixBlock prefixBlock = prefixBlockArray[p];
                    v3.add(new DEROctetString(prefixBlock.toEncBytes()));
                }
                v.add(new DERTaggedObject(332, new DERSequence((ASN1EncodableVector)v3)));
                break;
            }
            default: {
                throw new IOException("Error encoding prefix (unknown dump type " + dumpType.name() + ")");
            }
        }
        switch (dumpType) {
            case ALL_UNENCRYPTED: 
            case INTERNAL: {
                v2 = new ASN1EncodableVector();
                for (RoutingCombo p : this.nextHop) {
                    v2.add(p.toAsn1Object(dumpType));
                }
                v.add(new DERTaggedObject(333, new DERSequence(v2)));
                break;
            }
            case PRIVATE_COMMENTED: 
            case PUBLIC_ONLY: 
            case ALL: {
                v3 = new ASN1EncodableVector();
                for (RoutingCombo routingCombo : this.nextHop) {
                    v3.add(new DEROctetString(routingCombo.toEncBytes()));
                }
                v.add(new DERTaggedObject(334, new DERSequence((ASN1EncodableVector)v3)));
                break;
            }
            default: {
                throw new IOException("Error encoding prefix (unknown dump type " + dumpType.name() + ")");
            }
        }
        v.add(new ASN1Integer(this.forwardSecret));
        if (this.murbMaxReplay > 0L) {
            v2 = new ASN1EncodableVector();
            v2.add(this.murbReplyBlock.toAsn1Object(dumpType));
            v2.add(new ASN1Integer(this.murbMaxReplay));
            v2.add(this.murbValidity.toAsn1Object(dumpType));
            v.add(new DERTaggedObject(131, new DERSequence(v2)));
        }
        v2 = new ASN1EncodableVector();
        if (this.operation != null && !this.operation.isEmpty()) {
            for (Operation o : this.operation) {
                v2.add(o.toAsn1Object(dumpType));
            }
        }
        v.add(new DERTaggedObject(132, new DERSequence(v2)));
        return new DERSequence(v);
    }

    public boolean addOperation(Operation o) {
        return this.operation.add(o);
    }

    public byte[] toEncBytes() {
        return (byte[])this.encrypted.clone();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(prefix).append("  ").append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        RoutingCombo rb = (RoutingCombo)o;
        try {
            return Arrays.equals(rb.toBytes(DumpType.ALL_UNENCRYPTED), this.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        return this.prepareDump(this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED)).hashCode();
    }

    static {
        try {
            dummyKey = new AsymmetricKey();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "error while getting logging key for dummy blocks", ioe);
        }
    }
}

