/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.SizeCalc;
import org.bouncycastle.asn1.ASN1Enumerated;

public enum Padding implements Serializable
{
    NONE(1000, "NoPadding", new AlgorithmType[]{AlgorithmType.SYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8;
        }
    }),
    PKCS1(1001, "PKCS1Padding", new AlgorithmType[]{AlgorithmType.ASYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8 - 11;
        }
    }),
    OAEP_SHA256_MGF1(1100, "OAEPWithSHA256AndMGF1Padding", new AlgorithmType[]{AlgorithmType.ASYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8 - 2 - 64;
        }
    }),
    OAEP_SHA384_MGF1(1101, "OAEPWithSHA384AndMGF1Padding", new AlgorithmType[]{AlgorithmType.ASYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8 - 2 - 96;
        }
    }),
    OAEP_SHA512_MGF1(1102, "OAEPWithSHA512AndMGF1Padding", new AlgorithmType[]{AlgorithmType.ASYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8 - 2 - 128;
        }
    }),
    PKCS7(1007, "PKCS7Padding", new AlgorithmType[]{AlgorithmType.SYMMETRIC}, new SizeCalc(){

        @Override
        public int maxSize(int s) {
            return s / 8 - 1;
        }
    });

    public static final long serialVersionUID = 100000000038L;
    private static final Map<AlgorithmType, Padding> DEFAULT_PADDING;
    private final int id;
    private final String txt;
    private final Set<AlgorithmType> at;
    private final SizeCalc sizeCalculator;
    final ASN1Enumerated asn;

    private Padding(int id, String txt, AlgorithmType[] at, SizeCalc sizeCalculator) {
        this.id = id;
        this.txt = txt;
        this.at = new HashSet<AlgorithmType>();
        this.at.addAll(Arrays.asList(at));
        this.sizeCalculator = sizeCalculator;
        this.asn = new ASN1Enumerated(id);
    }

    public static Padding[] getAlgorithms(AlgorithmType at) {
        ArrayList<Padding> v = new ArrayList<Padding>();
        for (Padding val : Padding.values()) {
            if (!val.at.contains(at)) continue;
            v.add(val);
        }
        return v.toArray(new Padding[v.size()]);
    }

    public static Padding getById(int id) {
        for (Padding e : Padding.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public static Padding getByString(String name) {
        for (Padding e : Padding.values()) {
            if (!e.txt.equals(name)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Padding getDefault(AlgorithmType at) {
        Map<AlgorithmType, Padding> map = DEFAULT_PADDING;
        synchronized (map) {
            if (DEFAULT_PADDING.isEmpty()) {
                Map<AlgorithmType, Padding> map2 = DEFAULT_PADDING;
                synchronized (map2) {
                    DEFAULT_PADDING.clear();
                    DEFAULT_PADDING.put(AlgorithmType.ASYMMETRIC, PKCS1);
                    DEFAULT_PADDING.put(AlgorithmType.SYMMETRIC, PKCS7);
                }
            }
        }
        Padding p = DEFAULT_PADDING.get(at);
        if (p == null) {
            throw new NullPointerException("no default padding for " + String.valueOf(at));
        }
        return p;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.txt;
    }

    public int getMaxSize(int blockSize) {
        return this.sizeCalculator.maxSize(blockSize);
    }

    public ASN1Enumerated toAsn1() {
        return this.asn;
    }

    static {
        DEFAULT_PADDING = new HashMap<AlgorithmType, Padding>();
    }
}

