/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender;

import jakarta.activation.DataHandler;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.NotImplementedException;
import net.messagevortex.Version;
import net.messagevortex.asn1.BlendingSpec;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.blender.Blender;
import net.messagevortex.blender.BlendingReceiver;
import net.messagevortex.blender.generators.BlenderGenerator;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.dummy.DummyTransportTrx;

public class F5Blender
extends Blender {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private String identity;
    private Transport transport;
    private BlendingReceiver router;
    private IdentityStore identityStore;

    public F5Blender(String section) throws IOException {
        super(MessageVortexRepository.getRouter("", Config.getDefault().getSectionValue(section, "router")), null);
        String className = Config.getDefault().getSectionValue(section, "blender_generator");
        try {
            Class<?> clazz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("class \"" + className + "\" not found", cnfe);
        }
        BlenderGenerator blender = null;
        this.init(null, MessageVortexRepository.getRouter("", Config.getDefault().getSectionValue(section, "router")), new IdentityStore(), blender);
    }

    public F5Blender(String identity, BlendingReceiver router, IdentityStore identityStore, BlenderGenerator blender) throws IOException {
        super(router, null);
        this.init(identity, router, identityStore, blender);
    }

    private void init(String identity, BlendingReceiver router, IdentityStore identityStore, BlenderGenerator blender) throws IOException {
        this.identity = identity;
        this.transport = identity != null ? new DummyTransportTrx(identity, this) : null;
        this.router = router;
        if (identityStore == null) {
            throw new NullPointerException("identitystore may not be null");
        }
        this.identityStore = identityStore;
    }

    @Override
    public String getBlendingAddress() {
        return this.identity;
    }

    @Override
    public byte[] blendMessageToBytes(BlendingSpec nextHop, VortexMessage msg) {
        throw new NotImplementedException();
    }

    @Override
    public VortexMessage unblendMessage(byte[] blendedMessage) {
        return null;
    }

    @Override
    public boolean blendMessage(BlendingSpec target, VortexMessage msg) {
        try {
            Session session = Session.getInstance(new Properties(), new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("username", "password");
                }
            });
            session.setDebug(true);
            MimeMessage mimeMsg = new MimeMessage(session);
            mimeMsg.setFrom(new InternetAddress("test@test.com"));
            mimeMsg.setRecipient(Message.RecipientType.TO, new InternetAddress(target.getRecipientAddress()));
            mimeMsg.setSubject("VortexMessage");
            mimeMsg.setHeader("User-Agent:", "MessageVortex/" + Version.getStringVersion());
            MimeMultipart content = new MimeMultipart("mixed");
            MimeBodyPart body = new MimeBodyPart();
            body.setText("FIXME!!! This part is not coded yet");
            content.addBodyPart(body);
            MimeBodyPart attachment = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(msg.toBytes(DumpType.PUBLIC_ONLY), "application/octet-stream");
            attachment.setDataHandler(new DataHandler(source));
            attachment.setFileName("messageVortex.raw");
            content.addBodyPart(attachment);
            mimeMsg.setContent(content);
            if (this.transport != null) {
                PipedOutputStream os = new PipedOutputStream();
                PipedInputStream is = new PipedInputStream(os);
                SenderThread t = new SenderThread(mimeMsg, os);
                t.start();
                try {
                    this.transport.sendMessage(target.getRecipientAddress(), is);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.SEVERE, "Unable to send to transport endpoint " + target.getRecipientAddress(), ioe);
                    t.interrupt();
                }
                boolean res = t.getSuccess(30000L);
                LOGGER.log(Level.INFO, "message sent using dummy transport to " + target.getRecipientAddress() + " (result: " + res + ")");
                return res;
            }
            LOGGER.log(Level.SEVERE, "Transport endpoint not set");
            return false;
        }
        catch (AddressException ae) {
            LOGGER.log(Level.SEVERE, "Error when setting address", ae);
        }
        catch (MessagingException me) {
            LOGGER.log(Level.SEVERE, "Error when composing message", me);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to send to transport endpoint " + target.getRecipientAddress(), ioe);
        }
        return false;
    }

    @Override
    public boolean gotMessage(InputStream is) {
        try {
            Session session = Session.getInstance(new Properties(), new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("username", "password");
                }
            });
            MimeMessage msg = new MimeMessage(session, is);
            is.close();
            VortexMessage vmsg = null;
            List<InputStream> isl = this.getAttachments(msg);
            if (isl == null) {
                isl = new ArrayList<InputStream>();
            }
            for (InputStream attaStream : isl) {
                try {
                    vmsg = new VortexMessage(attaStream, this.identityStore.getHostIdentity());
                    LOGGER.log(Level.INFO, "Found attachment WITH VortexMessage contained");
                }
                catch (IOException io) {
                    LOGGER.log(Level.FINE, "Found attachment with no VortexMessage contained", io);
                }
                attaStream.close();
            }
            return this.router.gotMessage(vmsg);
        }
        catch (MessagingException | IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception while getting and parsing message", ioe);
            return false;
        }
    }

    private List<InputStream> getAttachments(Message message) throws MessagingException, IOException {
        Object content = message.getContent();
        if (content instanceof String) {
            return null;
        }
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            ArrayList<InputStream> result = new ArrayList<InputStream>();
            for (int i2 = 0; i2 < multipart.getCount(); ++i2) {
                result.addAll(this.getAttachments(multipart.getBodyPart(i2)));
            }
            return result;
        }
        return null;
    }

    private List<InputStream> getAttachments(BodyPart part) throws IOException, MessagingException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        Object content = part.getContent();
        if (content instanceof InputStream || content instanceof String) {
            if ("attachment".equalsIgnoreCase(part.getDisposition()) || !"".equals(part.getFileName())) {
                result.add(part.getInputStream());
                return result;
            }
            return new ArrayList<InputStream>();
        }
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i2 = 0; i2 < multipart.getCount(); ++i2) {
                BodyPart bodyPart = multipart.getBodyPart(i2);
                result.addAll(this.getAttachments(bodyPart));
            }
        }
        return result;
    }

    private static class SenderThread
    extends Thread {
        private final OutputStream output;
        private final MimeMessage msg;
        volatile boolean success = true;

        public SenderThread(MimeMessage msg, OutputStream os) {
            this.output = os;
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                LOGGER.log(Level.INFO, "streaming message to target");
                this.msg.writeTo(this.output);
                this.output.close();
            }
            catch (MessagingException | IOException ioe) {
                LOGGER.log(Level.WARNING, "streaming message to target failed", ioe);
                this.success = false;
                return;
            }
            LOGGER.log(Level.INFO, "streaming message to target done");
        }

        public boolean getSuccess(long millis) {
            try {
                this.join(millis);
                if (this.isAlive()) {
                    this.interrupt();
                    return false;
                }
                return this.success;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
    }
}

