/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router;

import net.messagevortex.asn1.IdentityStoreBlock;

public class Edge {
    private static final long serialVersionUID = 9070431563L;
    private final IdentityStoreBlock from;
    private final IdentityStoreBlock to;
    private long startTime = 0L;
    private long maxDelay = 10000L;

    public Edge(IdentityStoreBlock from, IdentityStoreBlock to, long startTime, long maxDelay) {
        if (from == null) {
            throw new NullPointerException("from may not be null in an edge");
        }
        if (to == null) {
            throw new NullPointerException("from may not be null in an edge");
        }
        if (from == to || from.equals(to)) {
            throw new IllegalArgumentException("an edge may not have the same start and ending point");
        }
        this.from = from;
        this.to = to;
        this.startTime = startTime;
        this.maxDelay = maxDelay;
    }

    public IdentityStoreBlock getFrom() {
        return this.from;
    }

    public IdentityStoreBlock getTo() {
        return this.to;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long setStartTime(long newStartTime) {
        long old = this.startTime;
        this.startTime = newStartTime;
        return old;
    }

    public long getDelayTime() {
        return this.maxDelay;
    }

    public long setDelayTime(long newMaxDelay) {
        long old = this.maxDelay;
        this.maxDelay = newMaxDelay;
        return old;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t.getClass() != this.getClass()) {
            return false;
        }
        Edge g = (Edge)t;
        return g.startTime == this.startTime && g.maxDelay == this.maxDelay && g.to.equals(this.to) && g.from.equals(this.from);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.from) + " -" + this.startTime + "/" + this.maxDelay + "-> " + String.valueOf(this.to);
    }
}

