/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.router.operation.MathMode;

public class Matrix {
    static boolean matrixCacheDisabled = false;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    static final int X = 0;
    static final int Y = 1;
    public static final int MAX_CACHE = 30;
    private static final Map<String, Matrix> matrixCache = new LinkedHashMap<String, Matrix>();
    int[] matrixContent;
    int[] dimension = new int[2];
    int modulo = Integer.MAX_VALUE;
    MathMode mode;

    public Matrix(Matrix originalMatrix) {
        this(originalMatrix.getX(), originalMatrix.getY(), originalMatrix.mode, originalMatrix.matrixContent);
        this.modulo = originalMatrix.modulo;
        this.dimension = Arrays.copyOf(this.dimension, this.dimension.length);
        this.matrixContent = Arrays.copyOf(this.matrixContent, this.matrixContent.length);
    }

    public Matrix(int x, int y, MathMode mode) {
        if (x < 1 || y < 1) {
            throw new IllegalArgumentException("null or negative matrix size exception (" + x + "/" + y + ")");
        }
        this.dimension[0] = x;
        this.dimension[1] = y;
        this.matrixContent = new int[x * y];
        if (mode != null) {
            this.mode = mode;
        }
    }

    public Matrix(int x, int y, MathMode mode, int[] content) {
        this(x, y, mode);
        this.matrixContent = Arrays.copyOf(content, content.length);
    }

    public Matrix(int x, int y, MathMode mode, byte[] content) {
        this(x, y, mode);
        this.matrixContent = new int[content.length];
        for (int i2 = 0; i2 < content.length; ++i2) {
            this.matrixContent[i2] = content[i2] & 0xFF;
        }
    }

    public Matrix(int x, int y, MathMode mode, int content) {
        this(x, y, mode);
        for (int i2 = 0; i2 < x * y; ++i2) {
            this.matrixContent[i2] = content;
        }
    }

    public static Matrix unitMatrix(int size, MathMode mode) {
        Matrix m;
        if (!matrixCacheDisabled && (m = Matrix.getCache("um" + size + "/" + String.valueOf(mode))) != null) {
            return new Matrix(m);
        }
        Matrix ret = new Matrix(size, size, mode);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                ret.matrixContent[y * size + x] = x != y ? 0 : 1;
            }
        }
        Matrix.addCache("um" + size + "/" + String.valueOf(mode), new Matrix(ret));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCache(String key, Matrix m) {
        Map<String, Matrix> map = matrixCache;
        synchronized (map) {
            if (matrixCacheDisabled) {
                return;
            }
            if (matrixCache.containsKey(key)) {
                return;
            }
            while (matrixCache.size() > 30) {
                matrixCache.remove(matrixCache.entrySet().iterator().next().getKey());
            }
            matrixCache.put(key, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Matrix getCache(String key) {
        Map<String, Matrix> map = matrixCache;
        synchronized (map) {
            return matrixCache.get(key);
        }
    }

    public int getX() {
        return this.dimension[0];
    }

    public int getY() {
        return this.dimension[1];
    }

    public void removeRow(int index) {
        int[] newMatrix = Arrays.copyOf(this.matrixContent, this.getX() * (this.getY() - 1));
        for (int i2 = (1 + index) * this.getX(); i2 < this.matrixContent.length; ++i2) {
            newMatrix[i2 - this.getX()] = this.matrixContent[i2];
        }
        this.dimension[1] = this.dimension[1] - 1;
        this.matrixContent = newMatrix;
    }

    public static Matrix randomMatrix(int x, int y, MathMode mode) {
        Matrix ret = new Matrix(x, y, mode);
        for (int xl = 0; xl < x; ++xl) {
            for (int yl = 0; yl < y; ++yl) {
                ret.matrixContent[x * yl + xl] = ExtendedSecureRandom.nextInt(Integer.MAX_VALUE);
            }
        }
        return ret;
    }

    public Matrix mul(Matrix m) {
        if (!this.mode.equals(m.mode)) {
            throw new ArithmeticException("illegal matrixContent math mode");
        }
        if (this.getX() != m.getY()) {
            throw new ArithmeticException("illegal matrixContent size");
        }
        Matrix ret = new Matrix(m.getX(), this.getY(), this.mode);
        for (int x = 0; x < m.dimension[0]; ++x) {
            for (int y = 0; y < this.dimension[1]; ++y) {
                ret.matrixContent[y * ret.dimension[0] + x] = 0;
                for (int i2 = 0; i2 < m.dimension[1]; ++i2) {
                    ret.matrixContent[y * ret.dimension[0] + x] = this.mode.add(ret.matrixContent[y * ret.dimension[0] + x], this.mode.mul(this.matrixContent[y * this.dimension[0] + i2], m.matrixContent[i2 * m.dimension[0] + x]));
                }
                ret.matrixContent[y * ret.dimension[0] + x] = ret.matrixContent[y * ret.dimension[0] + x] % this.modulo;
            }
        }
        return ret;
    }

    public boolean equals(Object o) {
        int i2;
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)o;
        if (m.dimension.length != this.dimension.length) {
            return false;
        }
        for (i2 = 0; this.dimension.length > i2; ++i2) {
            if (this.dimension[i2] == m.dimension[i2]) continue;
            return false;
        }
        for (i2 = 0; m.matrixContent.length > i2; ++i2) {
            if (this.matrixContent[i2] == m.matrixContent[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int y = 0; y < this.dimension[1]; ++y) {
            sb.append('{');
            for (int x = 0; x < this.dimension[0]; ++x) {
                if (x > 0) {
                    sb.append(',');
                }
                sb.append(this.matrixContent[y * this.dimension[0] + x]);
            }
            sb.append('}');
            if (y >= this.dimension[1] - 1) continue;
            sb.append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    public int setModulo(int i2) {
        int ret = this.modulo;
        if (i2 < 1) {
            this.modulo = Integer.MAX_VALUE;
        }
        this.modulo = i2;
        return ret;
    }

    public int[] getRow(int i2) {
        if (i2 < 0 || i2 >= this.dimension[1]) {
            throw new ArithmeticException("row index out of range 0<=i<" + this.dimension[0]);
        }
        int[] ret = new int[this.dimension[0]];
        for (int j = 0; j < ret.length; ++j) {
            ret[j] = this.getField(j, i2);
        }
        return ret;
    }

    public int getField(int x, int y) {
        this.checkField(x, y);
        return this.matrixContent[y * this.getX() + x];
    }

    public int setField(int x, int y, int value) {
        this.checkField(x, y);
        int old = this.getField(x, y);
        this.matrixContent[y * this.getX() + x] = value;
        return old;
    }

    private void checkField(int x, int y) {
        if (x < 0 || x >= this.dimension[0]) {
            throw new ArithmeticException("column index out of range 0<=col[" + x + "]<" + this.dimension[0]);
        }
        if (y < 0 || y >= this.dimension[1]) {
            throw new ArithmeticException("row index out of range 0<=row[" + y + "]<" + this.dimension[1]);
        }
    }

    public Matrix getInverse() {
        int row;
        if (this.dimension[0] != this.dimension[1]) {
            throw new ArithmeticException("matrixContent to inverse must have square dimensions (dimension is " + this.getX() + "/" + this.getY() + ")");
        }
        long startTime = System.currentTimeMillis();
        Matrix red = new Matrix(this);
        Matrix ret = Matrix.unitMatrix(this.dimension[0], this.mode);
        for (row = 0; row < this.getY(); ++row) {
            int scalar = red.getField(row, row);
            if (scalar == 0) {
                int flipRow;
                for (flipRow = row + 1; flipRow < this.getY() && red.getField(row, flipRow) == 0; ++flipRow) {
                }
                if (flipRow == this.getY()) {
                    throw new ArithmeticException("unable to inverse matrixContent (in flip row)");
                }
                LOGGER.log(Level.FINEST, "  processing flip row", new Object[]{row, flipRow});
                red.flipRow(row, flipRow);
                ret.flipRow(row, flipRow);
            }
            if ((scalar = red.getField(row, row)) != 1) {
                red.divRow(row, scalar);
                ret.divRow(row, scalar);
            }
            for (int row2 = row + 1; row2 < this.dimension[1]; ++row2) {
                scalar = red.getField(row, row2);
                if (scalar == 0) continue;
                red.transformRow(row2, row, scalar, false);
                ret.transformRow(row2, row, scalar, false);
            }
        }
        for (row = 1; row < this.dimension[0]; ++row) {
            for (int row2 = row - 1; row2 >= 0; --row2) {
                int scalar = red.getField(row, row2);
                if (scalar == 0) continue;
                red.transformRow(row2, row, scalar, false);
                ret.transformRow(row2, row, scalar, false);
            }
        }
        if (!Matrix.unitMatrix(red.dimension[0], this.mode).equals(red)) {
            throw new ArithmeticException("unable to calculate inverse");
        }
        long time = System.currentTimeMillis() - startTime;
        LOGGER.log(Level.FINE, "Got inverse matrix (" + this.dimension[0] + "/" + this.dimension[1] + ") in " + (double)time / 1000.0 + "s");
        return ret;
    }

    public byte[] getRowAsByteArray(int row) {
        byte[] ret = new byte[this.getX()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (byte)this.getField(i2, row);
        }
        return ret;
    }

    public byte[] getAsByteArray() {
        byte[] ret = new byte[this.getX() * this.getY()];
        for (int y = 0; y < this.getY(); ++y) {
            for (int x = 0; x < this.getX(); ++x) {
                ret[y * this.getX() + x] = (byte)this.getField(x, y);
            }
        }
        return ret;
    }

    public void transformColumn(int col, int col2, int scalar) {
        if (col < 0 || col > this.getX()) {
            throw new ArithmeticException("first column is out of range");
        }
        if (col2 > this.getX()) {
            throw new ArithmeticException("second column is out of range");
        }
        for (int row = 0; row < this.getY(); ++row) {
            int newValue;
            int value1 = this.getField(col, row);
            if (col2 < 0) {
                newValue = this.mode.div(value1, scalar);
            } else {
                int value2 = this.getField(col2, row);
                newValue = this.mode.sub(value1, this.mode.mul(value2, scalar));
            }
            this.setField(col, row, newValue);
        }
    }

    public void transformRow(int row, int row2, int scalar, boolean doDiv) {
        if (row < 0 || row > this.getY()) {
            throw new ArithmeticException("first row is out of range");
        }
        if (row2 < 0 || row2 > this.getX()) {
            throw new ArithmeticException("second row is out of range");
        }
        for (int col = 0; col < this.getX(); ++col) {
            int value1 = this.getField(col, row);
            int value2 = this.getField(col, row2);
            int tempValue = doDiv ? this.mode.div(value2, scalar) : this.mode.mul(value2, scalar);
            int newValue = this.mode.sub(value1, tempValue);
            this.setField(col, row, newValue);
        }
    }

    public void divRow(int row, int scalar) {
        if (row < 0 || row > this.getY()) {
            throw new ArithmeticException("first row is out of range");
        }
        for (int col = 0; col < this.getX(); ++col) {
            this.setField(col, row, this.mode.div(this.getField(col, row), scalar));
        }
    }

    public void flipRow(int row1, int row2) {
        for (int i2 = 0; i2 < this.getX(); ++i2) {
            int tmp = this.getField(i2, row1);
            this.setField(i2, row1, this.getField(i2, row2));
            this.setField(i2, row2, tmp);
        }
    }

    public static boolean enableMatrixCache(boolean enable) {
        boolean old = !matrixCacheDisabled;
        matrixCacheDisabled = !enable;
        return old;
    }
}

