/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.runtime.parser.node.BooleanPropertyExecutor;
import org.apache.velocity.runtime.parser.node.GetExecutor;
import org.apache.velocity.runtime.parser.node.MapGetExecutor;
import org.apache.velocity.runtime.parser.node.MapSetExecutor;
import org.apache.velocity.runtime.parser.node.PropertyExecutor;
import org.apache.velocity.runtime.parser.node.PutExecutor;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.runtime.parser.node.SetPropertyExecutor;
import org.apache.velocity.util.ArrayIterator;
import org.apache.velocity.util.ArrayListWrapper;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.EnumerationIterator;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.TypeConversionHandler;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;
import org.slf4j.Logger;

public class UberspectImpl
implements Uberspect,
RuntimeServicesAware {
    protected Logger log;
    protected Introspector introspector;
    protected TypeConversionHandler conversionHandler;
    protected RuntimeServices rsvc;

    @Override
    public void init() {
        this.introspector = new Introspector(this.log, this.conversionHandler);
    }

    public TypeConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    @Override
    public void setRuntimeServices(RuntimeServices rs) {
        String conversionHandlerClass;
        this.rsvc = rs;
        this.log = this.rsvc.getLog("introspection");
        Object conversionHandlerInstance = rs.getProperty("introspector.conversion_handler.instance");
        if (conversionHandlerInstance == null && (conversionHandlerClass = rs.getString("introspector.conversion_handler.class")) != null && !conversionHandlerClass.equals("none")) {
            try {
                conversionHandlerInstance = ClassUtils.getNewInstance(conversionHandlerClass);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ConversionHandler (" + conversionHandlerClass + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new VelocityException(err, cnfe);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + conversionHandlerClass + "'", ie);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Cannot access class '" + conversionHandlerClass + "'", ae);
            }
        }
        if (conversionHandlerInstance != null) {
            if (conversionHandlerInstance instanceof ConversionHandler) {
                this.log.warn("The ConversionHandler interface is deprecated - see the TypeConversionHandler interface");
                final ConversionHandler ch = (ConversionHandler)conversionHandlerInstance;
                this.conversionHandler = new TypeConversionHandler(){

                    @Override
                    public boolean isExplicitlyConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
                        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
                        if (formalClass != null) {
                            return ch.isExplicitlyConvertible(formalClass, actual, possibleVarArg);
                        }
                        return false;
                    }

                    @Override
                    public Converter<?> getNeededConverter(Type formal, Class<?> actual) {
                        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
                        if (formalClass != null) {
                            return ch.getNeededConverter(formalClass, actual);
                        }
                        return null;
                    }

                    @Override
                    public void addConverter(Type formal, Class<?> actual, Converter<?> converter) {
                        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
                        if (formalClass == null) {
                            throw new UnsupportedOperationException("This conversion handler doesn't know how to handle Type: " + formal.getTypeName());
                        }
                        ch.addConverter(formalClass, actual, converter);
                    }
                };
            } else {
                if (!(conversionHandlerInstance instanceof TypeConversionHandler)) {
                    String err = "The specified class or provided instance for the conversion handler (" + conversionHandlerInstance.getClass().getName() + ") does not implement " + TypeConversionHandler.class.getName() + "; Velocity is not initialized correctly.";
                    this.log.error(err);
                    throw new VelocityException(err, null, this.rsvc.getLogContext().getStackTrace());
                }
                this.conversionHandler = (TypeConversionHandler)conversionHandlerInstance;
            }
        }
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    @Override
    public Iterator getIterator(Object obj, Info i2) {
        block11: {
            if (obj.getClass().isArray()) {
                return new ArrayIterator(obj);
            }
            if (obj instanceof Iterable) {
                return ((Iterable)obj).iterator();
            }
            if (obj instanceof Map) {
                return ((Map)obj).values().iterator();
            }
            if (obj instanceof Iterator) {
                this.log.debug("The iterative object in the #foreach() loop at {} is of type java.util.Iterator.  Because it is not resettable, if used in more than once it may lead to unexpected results.", (Object)i2);
                return (Iterator)obj;
            }
            if (obj instanceof Enumeration) {
                this.log.debug("The iterative object in the #foreach() loop at {} is of type java.util.Enumeration.  Because it is not resettable, if used in more than once it may lead to unexpected results.", (Object)i2);
                return new EnumerationIterator((Enumeration)obj);
            }
            Class<?> type = obj.getClass();
            try {
                Method iter = type.getMethod("iterator", new Class[0]);
                Class<?> returns = iter.getReturnType();
                if (Iterator.class.isAssignableFrom(returns)) {
                    try {
                        return (Iterator)iter.invoke(obj, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        break block11;
                    }
                    catch (Exception e) {
                        throw new VelocityException("Error invoking the method 'iterator' on class '" + obj.getClass().getName() + "'", e, this.rsvc.getLogContext().getStackTrace());
                    }
                }
                this.log.debug("iterator() method of reference in #foreach loop at {} does not return a true Iterator.", (Object)i2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.log.debug("Could not determine type of iterator in #foreach loop at {}", (Object)i2);
        return null;
    }

    @Override
    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i2) {
        if (obj == null) {
            return null;
        }
        Method m = this.introspector.getMethod(obj.getClass(), methodName, args);
        if (m != null) {
            return new VelMethodImpl(m, false, this.getNeededConverters(m.getGenericParameterTypes(), args));
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            m = this.introspector.getMethod(ArrayListWrapper.class, methodName, args);
            if (m != null) {
                return new VelMethodImpl(m, true, this.getNeededConverters(m.getGenericParameterTypes(), args));
            }
        } else if (cls == Class.class && (m = this.introspector.getMethod((Class)obj, methodName, args)) != null) {
            return new VelMethodImpl(m, false, this.getNeededConverters(m.getGenericParameterTypes(), args));
        }
        return null;
    }

    private Converter<?>[] getNeededConverters(Type[] expected, Object[] provided) {
        if (this.conversionHandler == null) {
            return null;
        }
        int n = Math.min(expected.length, provided.length);
        Converter[] converters = null;
        for (int i2 = 0; i2 < n; ++i2) {
            Converter<?> converter;
            Object arg = provided[i2];
            if (arg == null || (converter = this.conversionHandler.getNeededConverter(expected[i2], arg.getClass())) == null) continue;
            if (converters == null) {
                converters = new Converter[expected.length];
            }
            converters[i2] = converter;
        }
        return converters;
    }

    @Override
    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i2) {
        if (obj == null) {
            return null;
        }
        Class<?> claz = obj.getClass();
        AbstractExecutor executor = new PropertyExecutor(this.log, this.introspector, claz, identifier);
        if (!executor.isAlive()) {
            executor = new MapGetExecutor(this.log, obj, identifier);
        }
        if (!executor.isAlive()) {
            executor = new GetExecutor(this.log, this.introspector, claz, identifier);
        }
        if (!executor.isAlive()) {
            executor = new BooleanPropertyExecutor(this.log, this.introspector, claz, identifier);
        }
        if (!executor.isAlive() && obj.getClass().isArray()) {
            executor = new BooleanPropertyExecutor(this.log, this.introspector, ArrayListWrapper.class, identifier, true);
        }
        return executor.isAlive() ? new VelGetterImpl(executor) : null;
    }

    @Override
    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i2) {
        if (obj == null) {
            return null;
        }
        Class<?> claz = obj.getClass();
        SetExecutor executor = new SetPropertyExecutor(this.log, this.introspector, claz, identifier, arg);
        if (!executor.isAlive()) {
            executor = new MapSetExecutor(this.log, claz, identifier);
        }
        if (!executor.isAlive()) {
            executor = new PutExecutor(this.log, this.introspector, claz, arg, identifier);
        }
        return executor.isAlive() ? new VelSetterImpl(executor) : null;
    }

    public static class VelSetterImpl
    implements VelPropertySet {
        private final SetExecutor setExecutor;

        public VelSetterImpl(SetExecutor setExecutor) {
            this.setExecutor = setExecutor;
        }

        private VelSetterImpl() {
            this.setExecutor = null;
        }

        @Override
        public Object invoke(Object o, Object value) throws IllegalAccessException, InvocationTargetException {
            return this.setExecutor.execute(o, value);
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.setExecutor.isAlive() ? this.setExecutor.getMethod().getName() : null;
        }
    }

    public static class VelGetterImpl
    implements VelPropertyGet {
        final AbstractExecutor getExecutor;

        public VelGetterImpl(AbstractExecutor exec) {
            this.getExecutor = exec;
        }

        private VelGetterImpl() {
            this.getExecutor = null;
        }

        @Override
        public Object invoke(Object o) throws IllegalAccessException, InvocationTargetException {
            return this.getExecutor.execute(o);
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.getExecutor.isAlive() ? this.getExecutor.getMethod().getName() : null;
        }
    }

    public static class VelMethodImpl
    implements VelMethod {
        final Method method;
        Boolean isVarArg;
        boolean wrapArray;
        Converter<?>[] converters;

        public VelMethodImpl(Method m) {
            this(m, false, null);
        }

        public VelMethodImpl(Method method, boolean wrapArray) {
            this(method, wrapArray, null);
        }

        public VelMethodImpl(Method method, boolean wrapArray, Converter<?>[] converters) {
            this.method = method;
            this.wrapArray = wrapArray;
            this.converters = converters;
        }

        private VelMethodImpl() {
            this.method = null;
        }

        @Override
        public Object invoke(Object o, Object[] actual) throws IllegalAccessException, InvocationTargetException {
            Class<?>[] formal;
            int index;
            if (this.wrapArray) {
                o = new ArrayListWrapper(o);
            }
            if (this.isVarArg() && actual.length >= (index = (formal = this.method.getParameterTypes()).length - 1)) {
                Class<?> type = formal[index].getComponentType();
                actual = this.handleVarArg(type, index, actual);
            }
            if (this.converters != null) {
                try {
                    for (int i2 = 0; i2 < actual.length; ++i2) {
                        if (this.converters[i2] == null) continue;
                        actual[i2] = this.converters[i2].convert(actual[i2]);
                    }
                }
                catch (ArithmeticException ae) {
                    throw new IllegalArgumentException(ae);
                }
            }
            return this.doInvoke(o, actual);
        }

        protected Object doInvoke(Object o, Object[] actual) throws IllegalAccessException, InvocationTargetException {
            return this.method.invoke(o, actual);
        }

        public boolean isVarArg() {
            if (this.isVarArg == null) {
                Class<?>[] formal = this.method.getParameterTypes();
                if (formal.length == 0) {
                    this.isVarArg = Boolean.FALSE;
                } else {
                    Class<?> last = formal[formal.length - 1];
                    this.isVarArg = last.isArray();
                }
            }
            return this.isVarArg;
        }

        private Object[] handleVarArg(Class<?> type, int index, Object[] actual) {
            if (actual.length == index) {
                Object[] newActual = new Object[actual.length + 1];
                System.arraycopy(actual, 0, newActual, 0, actual.length);
                newActual[index] = Array.newInstance(type, 0);
                actual = newActual;
            } else if (actual.length == index + 1 && actual[index] != null) {
                Class<?> argClass = actual[index].getClass();
                if (!argClass.isArray() && IntrospectionUtils.isMethodInvocationConvertible(type, argClass, false)) {
                    Object lastActual = Array.newInstance(type, 1);
                    Array.set(lastActual, 0, actual[index]);
                    actual[index] = lastActual;
                }
            } else if (actual.length > index + 1) {
                int size = actual.length - index;
                Object lastActual = Array.newInstance(type, size);
                for (int i2 = 0; i2 < size; ++i2) {
                    Array.set(lastActual, i2, actual[index + i2]);
                }
                Object[] newActual = new Object[index + 1];
                System.arraycopy(actual, 0, newActual, 0, index);
                newActual[index] = lastActual;
                actual = newActual;
            }
            return actual;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.method.getName();
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }
    }
}

