/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.TypeArguments;

public class MapConverter
extends AbstractConfigurationConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Map.class.isAssignableFrom(type) && !Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (null != value) {
            return value;
        }
        try {
            Map<Object, Object> map = this.instantiateMap(configuration, type, loader);
            Type elementType = MapConverter.findElementType(typeArguments);
            if (Object.class == elementType || String.class == elementType) {
                int size = configuration.getChildCount();
                for (int i2 = 0; i2 < size; ++i2) {
                    PlexusConfiguration element = configuration.getChild(i2);
                    map.put(element.getName(), this.fromExpression(element, evaluator));
                }
                return map;
            }
            Class<?> rawElementType = TypeArguments.getRawType(elementType);
            ConfigurationConverter c = lookup.lookupConverterForType(rawElementType);
            ParameterizedConfigurationConverter pc = rawElementType != elementType && c instanceof ParameterizedConfigurationConverter ? (ParameterizedConfigurationConverter)c : null;
            int size = configuration.getChildCount();
            for (int i3 = 0; i3 < size; ++i3) {
                Object elementValue;
                PlexusConfiguration element = configuration.getChild(i3);
                try {
                    elementValue = null != pc ? pc.fromConfiguration(lookup, element, rawElementType, TypeArguments.get(elementType), enclosingType, loader, evaluator, listener) : c.fromConfiguration(lookup, element, rawElementType, enclosingType, loader, evaluator, listener);
                }
                catch (ComponentConfigurationException e) {
                    elementValue = this.fromExpression(element, evaluator);
                    Logs.warn("Map in " + enclosingType + " declares value type as: {} but saw: {} at runtime", elementType, null != elementValue ? elementValue.getClass() : null);
                }
                map.put(element.getName(), elementValue);
            }
            return map;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Map<Object, Object> instantiateMap(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (null == implType || Modifier.isAbstract(implType.getModifiers())) {
            return new TreeMap<Object, Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Map)impl;
    }

    private static Type findElementType(Type[] typeArguments) {
        if (null != typeArguments && typeArguments.length > 1) {
            return typeArguments[1];
        }
        return Object.class;
    }
}

