/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.imap;

import jakarta.mail.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.eclipse.angus.mail.imap.ResyncData;
import org.eclipse.angus.mail.imap.protocol.MessageSet;
import org.eclipse.angus.mail.imap.protocol.UIDSet;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] msgs, Condition cond) {
        ArrayList<MessageSet> v = new ArrayList<MessageSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            int current = msg.getSequenceNumber();
            if (cond != null && !cond.test(msg)) continue;
            MessageSet set = new MessageSet();
            set.start = current;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    int next = msg.getSequenceNumber();
                    if (cond == null || cond.test(msg)) {
                        if (next == current + 1) {
                            current = next;
                        } else {
                            --i2;
                            break;
                        }
                    }
                }
                ++i2;
            }
            set.end = current;
            v.add(set);
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new MessageSet[0]);
    }

    public static MessageSet[] toMessageSetSorted(Message[] msgs, Condition cond) {
        msgs = (Message[])msgs.clone();
        Arrays.sort(msgs, new Comparator<Message>(){

            @Override
            public int compare(Message msg1, Message msg2) {
                return msg1.getMessageNumber() - msg2.getMessageNumber();
            }
        });
        return Utility.toMessageSet(msgs, cond);
    }

    public static UIDSet[] toUIDSet(Message[] msgs) {
        ArrayList<UIDSet> v = new ArrayList<UIDSet>(1);
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            IMAPMessage msg = (IMAPMessage)msgs[i2];
            if (msg.isExpunged()) continue;
            long current = msg.getUID();
            UIDSet set = new UIDSet();
            set.start = current;
            ++i2;
            while (i2 < msgs.length) {
                msg = (IMAPMessage)msgs[i2];
                if (!msg.isExpunged()) {
                    long next = msg.getUID();
                    if (next == current + 1L) {
                        current = next;
                    } else {
                        --i2;
                        break;
                    }
                }
                ++i2;
            }
            set.end = current;
            v.add(set);
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new UIDSet[0]);
    }

    public static UIDSet[] getResyncUIDSet(ResyncData rd) {
        return rd.getUIDSet();
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

