/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import javax.inject.Inject;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.ManagementDependencies;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependencyManagementRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="dependency-management", requiresDependencyResolution=ResolutionScope.TEST)
public class DependencyManagementReport
extends AbstractProjectInfoReport {
    private ManagementDependencies managementDependencies;
    protected final ArtifactMetadataSource artifactMetadataSource;
    private final RepositoryUtils repoUtils;

    @Inject
    protected DependencyManagementReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, RepositoryUtils repoUtils) {
        super(repositorySystem, i18n, projectBuilder);
        this.artifactMetadataSource = artifactMetadataSource;
        this.repoUtils = repoUtils;
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = this.getManagementDependencies().hasDependencies();
        }
        return result;
    }

    public void executeReport(Locale locale) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.getSession().getLocalRepository());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        buildingRequest.setPluginArtifactRepositories(this.pluginRepositories);
        buildingRequest.setProcessPlugins(false);
        DependencyManagementRenderer r = new DependencyManagementRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), this.getManagementDependencies(), this.artifactMetadataSource, this.repositorySystem, (ProjectBuildingRequest)buildingRequest, this.repoUtils, this.getLicenseMappings());
        r.render();
    }

    public String getOutputName() {
        return "dependency-management";
    }

    @Override
    protected String getI18Nsection() {
        return "dependency-management";
    }

    private ManagementDependencies getManagementDependencies() {
        if (this.managementDependencies != null) {
            return this.managementDependencies;
        }
        this.managementDependencies = this.project.getDependencyManagement() == null ? new ManagementDependencies(null) : new ManagementDependencies(this.project.getDependencyManagement().getDependencies());
        return this.managementDependencies;
    }
}

