/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="plugins", requiresDependencyResolution=ResolutionScope.TEST)
public class PluginsReport
extends AbstractProjectInfoReport {
    @Inject
    public PluginsReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder) {
        super(repositorySystem, i18n, projectBuilder);
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getBuildPlugins()) || !this.isEmpty(this.getProject().getReportPlugins());
        }
        return result;
    }

    public void executeReport(Locale locale) {
        PluginsRenderer r = new PluginsRenderer(this.getLog(), this.getSink(), locale, this.getI18N(locale), this.project.getBuildPlugins(), this.project.getReportPlugins(), this.project, this.projectBuilder, this.repositorySystem, this.getSession().getProjectBuildingRequest());
        r.render();
    }

    public String getOutputName() {
        return "plugins";
    }

    @Override
    protected String getI18Nsection() {
        return "plugins";
    }

    protected static class PluginsRenderer
    extends AbstractProjectInfoRenderer {
        private final Log log;
        private final List<Plugin> plugins;
        private final List<ReportPlugin> reports;
        private final MavenProject project;
        private final ProjectBuilder projectBuilder;
        private final RepositorySystem repositorySystem;
        private final ProjectBuildingRequest buildingRequest;

        public PluginsRenderer(Log log, Sink sink, Locale locale, I18N i18n, List<Plugin> plugins, List<ReportPlugin> reports, MavenProject project, ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ProjectBuildingRequest buildingRequest) {
            super(sink, i18n, locale);
            this.log = log;
            this.plugins = new ArrayList<Plugin>(plugins);
            this.reports = new ArrayList<ReportPlugin>(reports);
            this.project = project;
            this.projectBuilder = projectBuilder;
            this.repositorySystem = repositorySystem;
            this.buildingRequest = buildingRequest;
        }

        @Override
        protected String getI18Nsection() {
            return "plugins";
        }

        protected void renderBody() {
            this.renderSectionPlugins(true);
            this.renderSectionPlugins(false);
        }

        private void renderSectionPlugins(boolean isPlugins) {
            List<GAV> list = isPlugins ? GAV.pluginsToGAV(this.plugins) : GAV.reportPluginsToGAV(this.reports, this.project);
            String[] tableHeader = this.getPluginTableHeader();
            this.startSection(this.getI18nString(isPlugins ? "build.title" : "report.title"));
            if (list.isEmpty()) {
                this.paragraph(this.getI18nString(isPlugins ? "nolist" : "report.nolist"));
                this.endSection();
                return;
            }
            Collections.sort(list, this.getPluginComparator());
            this.startTable();
            this.tableHeader(tableHeader);
            DefaultProjectBuildingRequest buildRequest = new DefaultProjectBuildingRequest(this.buildingRequest);
            buildRequest.setRemoteRepositories(this.project.getPluginArtifactRepositories());
            buildRequest.setProcessPlugins(false);
            for (GAV plugin : list) {
                VersionRange versionRange = VersionRange.createFromVersion((String)plugin.getVersion());
                Artifact pluginArtifact = this.repositorySystem.createProjectArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange.toString());
                try {
                    MavenProject pluginProject = this.projectBuilder.build(pluginArtifact, (ProjectBuildingRequest)buildRequest).getProject();
                    this.tableRow(this.getPluginRow(pluginProject.getGroupId(), pluginProject.getArtifactId(), pluginProject.getVersion(), pluginProject.getUrl()));
                }
                catch (ProjectBuildingException e) {
                    this.log.info((CharSequence)("Could not build project for " + plugin.getArtifactId()), (Throwable)e);
                    this.tableRow(this.getPluginRow(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null));
                }
            }
            this.endTable();
            this.endSection();
        }

        private String[] getPluginTableHeader() {
            String groupId = this.getI18nString("dependency-management", "column.groupId");
            String artifactId = this.getI18nString("dependency-management", "column.artifactId");
            String version = this.getI18nString("dependency-management", "column.version");
            return new String[]{groupId, artifactId, version};
        }

        private String[] getPluginRow(String groupId, String artifactId, String version, String link) {
            artifactId = ProjectInfoReportUtils.getArtifactIdCell(artifactId, link);
            return new String[]{groupId, artifactId, version};
        }

        private Comparator<GAV> getPluginComparator() {
            return new Comparator<GAV>(){

                @Override
                public int compare(GAV a1, GAV a2) {
                    int result = a1.groupId.compareTo(a2.groupId);
                    if (result == 0) {
                        result = a1.artifactId.compareTo(a2.artifactId);
                    }
                    return result;
                }
            };
        }

        protected static String resolveReportPluginVersion(ReportPlugin reportPlugin, MavenProject project) {
            Plugin plugin;
            if (reportPlugin.getVersion() != null) {
                return reportPlugin.getVersion();
            }
            if (project.getBuild() != null && (plugin = PluginsRenderer.find(reportPlugin, project.getBuild().getPlugins())) != null && plugin.getVersion() != null) {
                return plugin.getVersion();
            }
            if (project.getBuild() != null && project.getBuild().getPluginManagement() != null && (plugin = PluginsRenderer.find(reportPlugin, project.getBuild().getPluginManagement().getPlugins())) != null && plugin.getVersion() != null) {
                return plugin.getVersion();
            }
            return "RELEASE";
        }

        private static Plugin find(ReportPlugin reportPlugin, List<Plugin> plugins) {
            if (plugins == null) {
                return null;
            }
            for (Plugin plugin : plugins) {
                if (!Objects.equals(plugin.getArtifactId(), reportPlugin.getArtifactId()) || !Objects.equals(plugin.getGroupId(), reportPlugin.getGroupId())) continue;
                return plugin;
            }
            return null;
        }

        private static class GAV {
            private final String groupId;
            private final String artifactId;
            private final String version;

            private GAV(Plugin plugin) {
                this.groupId = plugin.getGroupId();
                this.artifactId = plugin.getArtifactId();
                this.version = StringUtils.isEmpty((String)plugin.getVersion()) ? "RELEASE" : plugin.getVersion();
            }

            private GAV(ReportPlugin reportPlugin, MavenProject project) {
                this.groupId = reportPlugin.getGroupId();
                this.artifactId = reportPlugin.getArtifactId();
                this.version = PluginsRenderer.resolveReportPluginVersion(reportPlugin, project);
            }

            public String getGroupId() {
                return this.groupId;
            }

            public String getArtifactId() {
                return this.artifactId;
            }

            public String getVersion() {
                return this.version;
            }

            public static List<GAV> pluginsToGAV(List<Plugin> plugins) {
                ArrayList<GAV> result = new ArrayList<GAV>(plugins.size());
                for (Plugin plugin : plugins) {
                    result.add(new GAV(plugin));
                }
                return result;
            }

            public static List<GAV> reportPluginsToGAV(List<ReportPlugin> reportPlugins, MavenProject project) {
                ArrayList<GAV> result = new ArrayList<GAV>(reportPlugins.size());
                for (ReportPlugin reportPlugin : reportPlugins) {
                    result.add(new GAV(reportPlugin, project));
                }
                return result;
            }
        }
    }
}

