/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.multimap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractMultiMapAddEntryListenerMessageTask<P>
extends AbstractAddListenerMessageTask<P> {
    protected AbstractMultiMapAddEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        MultiMapService service = (MultiMapService)this.getService("hz:impl:multiMapService");
        MultiMapListener listener = new MultiMapListener();
        String name = this.getDistributedObjectName();
        Data key = this.getKey();
        boolean includeValue = this.shouldIncludeValue();
        if (this.isLocalOnly()) {
            return InternalCompletableFuture.newCompletedFuture(service.addLocalListener(name, listener, key, includeValue));
        }
        return service.addListenerAsync(name, listener, key, includeValue);
    }

    protected abstract boolean shouldIncludeValue();

    protected abstract boolean isLocalOnly();

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.getDistributedObjectName(), "listen");
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        String namespace = MultiMapService.lookupNamespace(this.nodeEngine, this.getDistributedObjectName());
        return namespace != null ? new UserCodeNamespacePermission(namespace, "use") : null;
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    public Data getKey() {
        return null;
    }

    protected abstract ClientMessage encodeEvent(Data var1, Data var2, Data var3, int var4, UUID var5, int var6);

    @Override
    protected String getUserCodeNamespace() {
        return MapService.lookupNamespace(this.nodeEngine, this.getDistributedObjectName());
    }

    private class MultiMapListener
    extends EntryAdapter<Object, Object> {
        private MultiMapListener() {
        }

        @Override
        public void onEntryEvent(EntryEvent event) {
            if (AbstractMultiMapAddEntryListenerMessageTask.this.endpoint.isAlive()) {
                if (!(event instanceof DataAwareEntryEvent)) {
                    throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
                }
                DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                Data key = dataAwareEntryEvent.getKeyData();
                Data value = dataAwareEntryEvent.getNewValueData();
                Data oldValue = dataAwareEntryEvent.getOldValueData();
                EntryEventType type = event.getEventType();
                UUID uuid = event.getMember().getUuid();
                AbstractMultiMapAddEntryListenerMessageTask.this.sendClientMessage(key, AbstractMultiMapAddEntryListenerMessageTask.this.encodeEvent(key, value, oldValue, type.getType(), uuid, 1));
            }
        }

        @Override
        public void onMapEvent(MapEvent event) {
            if (AbstractMultiMapAddEntryListenerMessageTask.this.endpoint.isAlive()) {
                EntryEventType type = event.getEventType();
                UUID uuid = event.getMember().getUuid();
                AbstractMultiMapAddEntryListenerMessageTask.this.sendClientMessage(null, AbstractMultiMapAddEntryListenerMessageTask.this.encodeEvent(null, null, null, type.getType(), uuid, event.getNumberOfEntriesAffected()));
            }
        }
    }
}

