/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema.event;

import com.hazelcast.shaded.org.everit.json.schema.CombinedSchema;
import com.hazelcast.shaded.org.everit.json.schema.Schema;
import com.hazelcast.shaded.org.everit.json.schema.ValidationException;
import com.hazelcast.shaded.org.everit.json.schema.event.CombinedSchemaValidationEvent;
import com.hazelcast.shaded.org.everit.json.schema.event.MismatchEvent;
import com.hazelcast.shaded.org.json.JSONObject;
import com.hazelcast.shaded.org.json.JSONTokener;
import java.util.Objects;

public class CombinedSchemaMismatchEvent
extends CombinedSchemaValidationEvent
implements MismatchEvent {
    private final ValidationException failure;

    public CombinedSchemaMismatchEvent(CombinedSchema schema, Schema subSchema, Object instance, ValidationException failure) {
        super(schema, subSchema, instance);
        this.failure = failure;
    }

    @Override
    public ValidationException getFailure() {
        return this.failure;
    }

    @Override
    void describeTo(JSONObject obj) {
        obj.put("type", "mismatch");
        obj.put("keyword", ((CombinedSchema)this.schema).getCriterion().toString());
        obj.put("subSchema", new JSONTokener(this.subSchema.toString()).nextValue());
        obj.put("failure", this.failure.toJSON());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CombinedSchemaMismatchEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CombinedSchemaMismatchEvent that = (CombinedSchemaMismatchEvent)o;
        return this.failure.equals(that.failure);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.failure);
    }

    @Override
    boolean canEqual(Object o) {
        return o instanceof CombinedSchemaMismatchEvent;
    }
}

