/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.blame;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.blame.SvnBlameConsumer;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnBlameCommand
extends AbstractBlameCommand
implements SvnCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        int exitCode;
        Commandline cl = SvnBlameCommand.createCommandLine((SvnScmProviderRepository)repo, workingDirectory.getBasedir(), filename);
        SvnBlameConsumer consumer = new SvnBlameConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily((String)"windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new BlameScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new BlameScmResult(cl.toString(), consumer.getLines());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String filename) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArg().setValue("blame");
        cl.createArg().setValue("--xml");
        cl.createArg().setValue(filename);
        return cl;
    }
}

