package net.messagevortex.router.operation;
// ************************************************************************************
// * Copyright (c) 2018 Martin Gwerder (martin@gwerder.net)
// *
// * Permission is hereby granted, free of charge, to any person obtaining a copy
// * of this software and associated documentation files (the "Software"), to deal
// * in the Software without restriction, including without limitation the rights
// * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// * copies of the Software, and to permit persons to whom the Software is
// * furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included in all
// * copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// * SOFTWARE.
// ************************************************************************************

/**
 * Created by martin.gwerder on 20.04.2017.
 */
public class RealMathMode implements MathMode {

  private static final RealMathMode real = new RealMathMode();

  private RealMathMode() {
  }

  public static RealMathMode getRealMathMode() {
    return real;
  }

  @Override
  public int mul(int c1, int c2) {
    return c1 * c2;
  }

  @Override
  public int div(int c1, int c2) {
    return c1 / c2;
  }

  @Override
  public int add(int c1, int c2) {
    return c1 + c2;
  }

  @Override
  public int sub(int c1, int c2) {
    return c1 - c2;
  }

  @Override
  public String toString() {
    return "Real";
  }
}
